/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.chat;

import dev.langchain4j.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.model.zhipu.shared.Usage;
import java.util.List;

public final class ChatCompletionResponse {
    private final String id;
    private final Integer created;
    private final String model;
    private final List<ChatCompletionChoice> choices;
    private final Usage usage;

    private ChatCompletionResponse(Builder builder) {
        this.id = builder.id;
        this.created = builder.created;
        this.model = builder.model;
        this.choices = builder.choices;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String content() {
        return this.getChoices().get(0).getMessage().getContent();
    }

    public String getId() {
        return this.id;
    }

    public Integer getCreated() {
        return this.created;
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatCompletionChoice> getChoices() {
        return this.choices;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "ChatCompletionResponse(id=" + this.getId() + ", created=" + this.getCreated() + ", model=" + this.getModel() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionResponse)) {
            return false;
        }
        ChatCompletionResponse other = (ChatCompletionResponse)o;
        Integer this$created = this.getCreated();
        Integer other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatCompletionChoice> this$choices = this.getChoices();
        List<ChatCompletionChoice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        Usage this$usage = this.getUsage();
        Usage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatCompletionChoice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        Usage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public static final class Builder {
        private String id;
        private Integer created;
        private String model;
        private List<ChatCompletionChoice> choices;
        private Usage usage;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(Integer created) {
            this.created = created;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder choices(List<ChatCompletionChoice> choices) {
            this.choices = choices;
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public ChatCompletionResponse build() {
            return new ChatCompletionResponse(this);
        }
    }
}

