/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.document.Document;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import dev.tinyflow.core.knowledge.Knowledge;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeNode
extends BaseNode {
    private static final Logger logger = LoggerFactory.getLogger(KnowledgeNode.class);
    private Object knowledgeId;
    private Knowledge knowledge;
    private String keyword;
    private String limit;

    public Object getKnowledgeId() {
        return this.knowledgeId;
    }

    public void setKnowledgeId(Object knowledgeId) {
        this.knowledgeId = knowledgeId;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    protected Map<String, Object> execute(Chain chain) {
        Map argsMap = chain.getParameterValues((ChainNode)this);
        String realKeyword = TextPromptTemplate.of((String)this.keyword).formatToString(argsMap);
        String realLimitString = TextPromptTemplate.of((String)this.limit).formatToString(argsMap);
        int realLimit = 10;
        if (StringUtil.hasText((String)realLimitString)) {
            try {
                realLimit = Integer.parseInt(realLimitString);
            }
            catch (Exception e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
        if (this.knowledge == null) {
            return Collections.emptyMap();
        }
        List<Document> result = this.knowledge.search(realKeyword, realLimit, this, chain);
        return Maps.of((String)"documents", result);
    }

    public String toString() {
        return "KnowledgeNode{knowledgeId=" + this.knowledgeId + ", knowledge=" + this.knowledge + ", keyword='" + this.keyword + '\'' + ", limit='" + this.limit + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

