/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;

public class VolumeMountBuilder
extends VolumeMountFluentImpl<VolumeMountBuilder>
implements VisitableBuilder<VolumeMount, VolumeMountBuilder> {
    VolumeMountFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeMountBuilder() {
        this(true);
    }

    public VolumeMountBuilder(Boolean validationEnabled) {
        this(new VolumeMount(), validationEnabled);
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeMount(), validationEnabled);
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent, VolumeMount instance) {
        this(fluent, instance, true);
    }

    public VolumeMountBuilder(VolumeMountFluent<?> fluent, VolumeMount instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMountPath(instance.getMountPath());
        fluent.withMountPropagation(instance.getMountPropagation());
        fluent.withName(instance.getName());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withSubPath(instance.getSubPath());
        fluent.withSubPathExpr(instance.getSubPathExpr());
        this.validationEnabled = validationEnabled;
    }

    public VolumeMountBuilder(VolumeMount instance) {
        this(instance, (Boolean)true);
    }

    public VolumeMountBuilder(VolumeMount instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMountPath(instance.getMountPath());
        this.withMountPropagation(instance.getMountPropagation());
        this.withName(instance.getName());
        this.withReadOnly(instance.getReadOnly());
        this.withSubPath(instance.getSubPath());
        this.withSubPathExpr(instance.getSubPathExpr());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public VolumeMount build() {
        VolumeMount buildable = new VolumeMount(this.fluent.getMountPath(), this.fluent.getMountPropagation(), this.fluent.getName(), this.fluent.isReadOnly(), this.fluent.getSubPath(), this.fluent.getSubPathExpr());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeMountBuilder that = (VolumeMountBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

