package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressStatusBuilder extends IngressStatusFluentImpl<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder> {

    IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IngressStatusBuilder() {
        this(true);
    }

    public IngressStatusBuilder(Boolean validationEnabled) {
        this(new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance) {
        this(fluent, instance, true);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLoadBalancer(instance.getLoadBalancer()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressStatusBuilder(IngressStatus instance) {
        this(instance,true);
    }

    public IngressStatusBuilder(IngressStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLoadBalancer(instance.getLoadBalancer()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressStatus build() {
        IngressStatus buildable = new IngressStatus(fluent.getLoadBalancer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressStatusBuilder that = (IngressStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
