/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6.extensions;

import io.fabric8.kubernetes.api.builder.v4_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_6.Nested;
import io.fabric8.kubernetes.api.model.v4_6.IntOrString;
import io.fabric8.kubernetes.api.model.v4_6.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.v4_6.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressBackendFluent;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private String serviceName;
    private IntOrStringBuilder servicePort;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    public A withNewServiceName(String arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuilder arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuffer arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    @Deprecated
    public IntOrString getServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public IntOrString buildServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public A withServicePort(IntOrString servicePort) {
        this._visitables.get("servicePort").remove(this.servicePort);
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.get("servicePort").add(this.servicePort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServicePort() {
        return this.servicePort != null;
    }

    @Override
    public A withNewServicePort(String strVal) {
        return this.withServicePort(new IntOrString(strVal));
    }

    @Override
    public A withNewServicePort(Integer intVal) {
        return this.withServicePort(new IntOrString(intVal));
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(this.getServicePort());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : new IntOrStringBuilder().build());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        return !(this.servicePort != null ? !this.servicePort.equals(that.servicePort) : that.servicePort != null);
    }

    public class ServicePortNestedImpl<N>
    extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>>
    implements IngressBackendFluent.ServicePortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withServicePort(this.builder.build());
        }

        @Override
        public N endServicePort() {
            return this.and();
        }
    }
}

