/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6.extensions;

import io.fabric8.kubernetes.api.builder.v4_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_6.Nested;
import io.fabric8.kubernetes.api.builder.v4_6.Predicate;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressBackendFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.v4_6.extensions.IngressTLSFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private IngressBackendBuilder backend;
    private List<IngressRuleBuilder> rules;
    private List<IngressTLSBuilder> tls;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
    }

    @Override
    @Deprecated
    public IngressBackend getBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public A withBackend(IngressBackend backend) {
        this._visitables.get("backend").remove(this.backend);
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackend() {
        return this.backend != null;
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public A addToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<IngressRule> items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressRule> getRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public List<IngressRule> buildRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> setNewRuleLike(int index, IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        this._visitables.get("tls").add(index >= 0 ? index : this._visitables.get("tls").size(), builder);
        this.tls.add(index >= 0 ? index : this.tls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        if (index < 0 || index >= this._visitables.get("tls").size()) {
            this._visitables.get("tls").add(builder);
        } else {
            this._visitables.get("tls").set(index, builder);
        }
        if (index < 0 || index >= this.tls.size()) {
            this.tls.add(builder);
        } else {
            this.tls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTls(IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTls(Collection<IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTls(IngressTLS ... items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTls(Collection<IngressTLS> items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressTLS> getTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public List<IngressTLS> buildTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public IngressTLS buildTl(int index) {
        return this.tls.get(index).build();
    }

    @Override
    public IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    @Override
    public IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    @Override
    public IngressTLS buildMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTls(List<IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get("tls").removeAll(this.tls);
        }
        if (tls != null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withTls(IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
        }
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item) {
        return new TlsNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> setNewTlLike(int index, IngressTLS item) {
        return new TlsNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.apply(this.tls.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public class TlsNestedImpl<N>
    extends IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>>
    implements IngressSpecFluent.TlsNested<N>,
    Nested<N> {
        private final IngressTLSBuilder builder;
        private final int index;

        TlsNestedImpl(int index, IngressTLS item) {
            this.index = index;
            this.builder = new IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.index = -1;
            this.builder = new IngressTLSBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToTls(this.index, this.builder.build());
        }

        @Override
        public N endTl() {
            return this.and();
        }
    }

    public class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>>
    implements IngressSpecFluent.RulesNested<N>,
    Nested<N> {
        private final IngressRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>>
    implements IngressSpecFluent.BackendNested<N>,
    Nested<N> {
        private final IngressBackendBuilder builder;

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

