/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_6.handlers;

import io.fabric8.kubernetes.api.model.v4_6.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v4_6.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.clnt.v4_6.Config;
import io.fabric8.kubernetes.clnt.v4_6.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_6.Watch;
import io.fabric8.kubernetes.clnt.v4_6.Watcher;
import io.fabric8.kubernetes.clnt.v4_6.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.StatefulSetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StatefulSetHandler
implements ResourceHandler<StatefulSet, StatefulSetBuilder> {
    @Override
    public String getKind() {
        return StatefulSet.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public StatefulSet create(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new StatefulSet[0]);
    }

    @Override
    public StatefulSet replace(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public StatefulSet reload(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((Gettable)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StatefulSetBuilder edit(StatefulSet item) {
        return new StatefulSetBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, StatefulSet item) {
        return (Boolean)new StatefulSetOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, String resourceVersion, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public StatefulSet waitUntilReady(OkHttpClient client, Config config, String namespace, StatefulSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StatefulSet waitUntilCondition(OkHttpClient client, Config config, String namespace, StatefulSet item, Predicate<StatefulSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

