/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_6.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.v4_6.KubernetesResource;
import io.fabric8.kubernetes.clnt.v4_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_6.utils.ReplaceValueStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String DOCUMENT_DELIMITER = "---";

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) throws KubernetesClientException {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) throws KubernetesClientException {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is) throws KubernetesClientException {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, Map<String, String> parameters) throws KubernetesClientException {
        String specFile = Serialization.readSpecFileFromInputStream(is);
        if (Serialization.containsMultipleDocuments(specFile)) {
            return (T)Serialization.getKubernetesResourceList(parameters, specFile);
        }
        return Serialization.unmarshal((InputStream)new ByteArrayInputStream(specFile.getBytes()), JSON_MAPPER, parameters);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        InputStream wrapped = parameters != null && !parameters.isEmpty() ? new ReplaceValueStream(parameters).createInputStream(is) : is;
        try (BufferedInputStream bis = new BufferedInputStream(wrapped);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readerFor(KubernetesResource.class).readValue((InputStream)bis);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(str, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            }, parameters);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }, parameters);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type, Map<String, String> parameters) throws KubernetesClientException {
        InputStream wrapped = parameters != null && !parameters.isEmpty() ? new ReplaceValueStream(parameters).createInputStream(is) : is;
        try (BufferedInputStream bis = new BufferedInputStream(wrapped);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static List<KubernetesResource> getKubernetesResourceList(Map<String, String> parameters, String specFile) {
        String[] documents;
        ArrayList<KubernetesResource> documentList = new ArrayList<KubernetesResource>();
        for (String document : documents = Serialization.splitSpecFile(specFile)) {
            if (!Serialization.validate(document)) continue;
            ByteArrayInputStream documentInputStream = new ByteArrayInputStream(document.getBytes());
            Object resource = Serialization.unmarshal((InputStream)documentInputStream, parameters);
            documentList.add((KubernetesResource)resource);
        }
        return documentList;
    }

    private static boolean containsMultipleDocuments(String specFile) {
        String[] documents = Serialization.splitSpecFile(specFile);
        int nValidDocuments = 0;
        for (String document : documents) {
            if (!Serialization.validate(document)) continue;
            ++nValidDocuments;
        }
        return nValidDocuments > 1;
    }

    private static String[] splitSpecFile(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        String[] lines = aSpecFile.split(System.lineSeparator());
        StringBuilder builder = new StringBuilder();
        for (int nLine = 0; nLine < lines.length; ++nLine) {
            if (lines[nLine].length() >= DOCUMENT_DELIMITER.length() && !lines[nLine].substring(0, DOCUMENT_DELIMITER.length()).equals(DOCUMENT_DELIMITER) || lines[nLine].length() < DOCUMENT_DELIMITER.length()) {
                builder.append(lines[nLine] + System.lineSeparator());
                continue;
            }
            documents.add(builder.toString());
            builder.setLength(0);
        }
        if (!builder.toString().isEmpty()) {
            documents.add(builder.toString());
        }
        return documents.toArray(new String[documents.size()]);
    }

    private static boolean validate(String document) {
        Matcher keyValueMatcher = Pattern.compile("(\\S+):\\s(\\S*)(?:\\b(?!:)|$)").matcher(document);
        return !document.isEmpty() && keyValueMatcher.find();
    }

    private static String readSpecFileFromInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read InputStream." + e);
        }
    }
}

