/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_6;

import io.fabric8.kubernetes.api.model.v4_6.Binding;
import io.fabric8.kubernetes.api.model.v4_6.ComponentStatus;
import io.fabric8.kubernetes.api.model.v4_6.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v4_6.ConfigMap;
import io.fabric8.kubernetes.api.model.v4_6.ConfigMapList;
import io.fabric8.kubernetes.api.model.v4_6.Doneable;
import io.fabric8.kubernetes.api.model.v4_6.DoneableBinding;
import io.fabric8.kubernetes.api.model.v4_6.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v4_6.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v4_6.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v4_6.DoneableEvent;
import io.fabric8.kubernetes.api.model.v4_6.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v4_6.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v4_6.DoneableNode;
import io.fabric8.kubernetes.api.model.v4_6.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v4_6.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_6.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_6.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v4_6.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v4_6.DoneableSecret;
import io.fabric8.kubernetes.api.model.v4_6.DoneableService;
import io.fabric8.kubernetes.api.model.v4_6.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_6.Endpoints;
import io.fabric8.kubernetes.api.model.v4_6.EndpointsList;
import io.fabric8.kubernetes.api.model.v4_6.Event;
import io.fabric8.kubernetes.api.model.v4_6.EventList;
import io.fabric8.kubernetes.api.model.v4_6.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_6.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_6.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_6.LimitRange;
import io.fabric8.kubernetes.api.model.v4_6.LimitRangeList;
import io.fabric8.kubernetes.api.model.v4_6.Namespace;
import io.fabric8.kubernetes.api.model.v4_6.NamespaceList;
import io.fabric8.kubernetes.api.model.v4_6.Node;
import io.fabric8.kubernetes.api.model.v4_6.NodeList;
import io.fabric8.kubernetes.api.model.v4_6.PersistentVolume;
import io.fabric8.kubernetes.api.model.v4_6.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_6.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v4_6.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v4_6.Pod;
import io.fabric8.kubernetes.api.model.v4_6.PodList;
import io.fabric8.kubernetes.api.model.v4_6.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_6.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v4_6.ResourceQuota;
import io.fabric8.kubernetes.api.model.v4_6.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v4_6.RootPaths;
import io.fabric8.kubernetes.api.model.v4_6.Secret;
import io.fabric8.kubernetes.api.model.v4_6.SecretList;
import io.fabric8.kubernetes.api.model.v4_6.Service;
import io.fabric8.kubernetes.api.model.v4_6.ServiceAccount;
import io.fabric8.kubernetes.api.model.v4_6.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v4_6.ServiceList;
import io.fabric8.kubernetes.api.model.v4_6.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_6.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v4_6.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_6.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.BaseClient;
import io.fabric8.kubernetes.clnt.v4_6.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.Config;
import io.fabric8.kubernetes.clnt.v4_6.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_6.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_6.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_6.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_6.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.SettingsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_6.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_6.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v4_6.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_6.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_6.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_6.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v4_6.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_6.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.SettingsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.SubjectAccessReviewDSL;
import io.fabric8.kubernetes.clnt.v4_6.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.ClusterOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.CustomResourceDefinitionOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_6.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_6.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v4_6.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v4_6.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v4_6.utils.Serialization;
import io.fabric8.openshift.api.model.v4_6.Build;
import io.fabric8.openshift.api.model.v4_6.BuildConfig;
import io.fabric8.openshift.api.model.v4_6.BuildConfigList;
import io.fabric8.openshift.api.model.v4_6.BuildList;
import io.fabric8.openshift.api.model.v4_6.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_6.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_6.DoneableBuild;
import io.fabric8.openshift.api.model.v4_6.DoneableBuildConfig;
import io.fabric8.openshift.api.model.v4_6.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.v4_6.DoneableGroup;
import io.fabric8.openshift.api.model.v4_6.DoneableImageStream;
import io.fabric8.openshift.api.model.v4_6.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.v4_6.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.v4_6.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_6.DoneableOAuthClient;
import io.fabric8.openshift.api.model.v4_6.DoneableOpenshiftClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_6.DoneableOpenshiftRole;
import io.fabric8.openshift.api.model.v4_6.DoneableOpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_6.DoneableProject;
import io.fabric8.openshift.api.model.v4_6.DoneableRoute;
import io.fabric8.openshift.api.model.v4_6.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_6.DoneableTemplate;
import io.fabric8.openshift.api.model.v4_6.DoneableUser;
import io.fabric8.openshift.api.model.v4_6.Group;
import io.fabric8.openshift.api.model.v4_6.GroupList;
import io.fabric8.openshift.api.model.v4_6.ImageStream;
import io.fabric8.openshift.api.model.v4_6.ImageStreamList;
import io.fabric8.openshift.api.model.v4_6.ImageStreamTag;
import io.fabric8.openshift.api.model.v4_6.ImageStreamTagList;
import io.fabric8.openshift.api.model.v4_6.OAuthAccessToken;
import io.fabric8.openshift.api.model.v4_6.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v4_6.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_6.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v4_6.OAuthClient;
import io.fabric8.openshift.api.model.v4_6.OAuthClientList;
import io.fabric8.openshift.api.model.v4_6.OpenshiftClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_6.OpenshiftClusterRoleBindingList;
import io.fabric8.openshift.api.model.v4_6.OpenshiftRole;
import io.fabric8.openshift.api.model.v4_6.OpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_6.OpenshiftRoleBindingList;
import io.fabric8.openshift.api.model.v4_6.OpenshiftRoleList;
import io.fabric8.openshift.api.model.v4_6.Project;
import io.fabric8.openshift.api.model.v4_6.ProjectList;
import io.fabric8.openshift.api.model.v4_6.Route;
import io.fabric8.openshift.api.model.v4_6.RouteList;
import io.fabric8.openshift.api.model.v4_6.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_6.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v4_6.Template;
import io.fabric8.openshift.api.model.v4_6.TemplateList;
import io.fabric8.openshift.api.model.v4_6.User;
import io.fabric8.openshift.api.model.v4_6.UserList;
import io.fabric8.openshift.clnt.v4_6.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v4_6.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_6.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v4_6.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v4_6.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v4_6.dsl.BuildResource;
import io.fabric8.openshift.clnt.v4_6.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.clnt.v4_6.dsl.CreateableSelfSubjectAccessReview;
import io.fabric8.openshift.clnt.v4_6.dsl.CreateableSelfSubjectRulesReview;
import io.fabric8.openshift.clnt.v4_6.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.clnt.v4_6.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v4_6.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v4_6.dsl.SubjectAccessReviewOperation;
import io.fabric8.openshift.clnt.v4_6.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OpenshiftClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OpenshiftRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.OpenshiftRoleOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.SubjectAccessReviewOperationImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.clnt.v4_6.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private static final String API_GROUPS_ENABLED = "API_GROUPS_ENABLED";
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new HashMap<String, Boolean>();
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super(DefaultOpenShiftClient.configWithApiGroupsEnabled(DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(config), config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(this.httpClient, config);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, DefaultOpenShiftClient.configWithApiGroupsEnabled(httpClient, config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(httpClient, this.getConfiguration());
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    private static OpenShiftConfig configWithApiGroupsEnabled(OkHttpClient httpClient, OpenShiftConfig config) {
        String url = config.getMasterUrl();
        Boolean openshiftApiGroupsEnabled = API_GROUPS_ENABLED_PER_URL.containsKey(url);
        if (openshiftApiGroupsEnabled.booleanValue()) {
            return config;
        }
        if (!config.isDisableApiGroupCheck()) {
            return config.withOpenshiftApiGroupsEnabled(false);
        }
        Boolean enabled = OpenshiftAdapterSupport.isOpenShiftAPIGroups(httpClient, url);
        API_GROUPS_ENABLED_PER_URL.put(url, enabled);
        return config.withOpenshiftApiGroupsEnabled(enabled);
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(Config config) {
        return DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(null, config);
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient, Config config) {
        OkHttpClient.Builder builder = httpClient != null ? httpClient.newBuilder().authenticator(Authenticator.NONE) : new OkHttpClient.Builder().authenticator(Authenticator.NONE);
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(config))).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList, DoneableBinding, Resource<Binding, DoneableBinding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public SubjectAccessReviewDSL subjectAccessReviewAuth() {
        return this.delegate.subjectAccessReviewAuth();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrd(crd).withType(resourceType).withListType(listClass).withDoneableType(doneClass));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftRole, OpenshiftRoleList, DoneableOpenshiftRole, Resource<OpenshiftRole, DoneableOpenshiftRole>> roles() {
        return new OpenshiftRoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftRoleBinding, OpenshiftRoleBindingList, DoneableOpenshiftRoleBinding, Resource<OpenshiftRoleBinding, DoneableOpenshiftRoleBinding>> roleBindings() {
        return new OpenshiftRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview, CreateableSelfSubjectAccessReview, CreateableSelfSubjectRulesReview> subjectAccessReviews() {
        return new SubjectAccessReviewOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftClusterRoleBinding, OpenshiftClusterRoleBindingList, DoneableOpenshiftClusterRoleBinding, Resource<OpenshiftClusterRoleBinding, DoneableOpenshiftClusterRoleBinding>> clusterRoleBindings() {
        return new OpenshiftClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new ClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.adapt(SettingsAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(ForkJoinPool.commonPool(), this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(executorService, this.httpClient, this.getConfiguration());
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

