/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.server.spring.auto.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.a2ap.core.model.AgentAuthentication;
import io.github.a2ap.core.model.AgentCapabilities;
import io.github.a2ap.core.model.AgentCard;
import io.github.a2ap.core.model.AgentProvider;
import io.github.a2ap.core.model.AgentSkill;
import io.github.a2ap.core.model.RequestContext;
import io.github.a2ap.core.model.SecurityScheme;
import io.github.a2ap.core.server.A2AServer;
import io.github.a2ap.core.server.AgentExecutor;
import io.github.a2ap.core.server.Dispatcher;
import io.github.a2ap.core.server.EventQueue;
import io.github.a2ap.core.server.QueueManager;
import io.github.a2ap.core.server.TaskManager;
import io.github.a2ap.core.server.TaskStore;
import io.github.a2ap.core.server.impl.DefaultA2AServer;
import io.github.a2ap.core.server.impl.DefaultDispatcher;
import io.github.a2ap.core.server.impl.InMemoryQueueManager;
import io.github.a2ap.core.server.impl.InMemoryTaskManager;
import io.github.a2ap.core.server.impl.InMemoryTaskStore;
import io.github.a2ap.server.spring.auto.configuration.A2AServerProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@EnableConfigurationProperties(value={A2AServerProperties.class})
@AutoConfigureAfter(value={A2AServerProperties.class})
public class A2AServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public QueueManager queueManager() {
        return new InMemoryQueueManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskStore taskStore() {
        return new InMemoryTaskStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public TaskManager taskManager(TaskStore taskStore) {
        return new InMemoryTaskManager(taskStore);
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public Dispatcher dispatcher(A2AServer a2aServer, ObjectMapper objectMapper) {
        return new DefaultDispatcher(a2aServer, objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public AgentExecutor agentExecutor() {
        return new AgentExecutor(){

            public Mono<Void> execute(RequestContext context, EventQueue eventQueue) {
                eventQueue.close();
                return Mono.empty();
            }

            public Mono<Void> cancel(String taskId) {
                return Mono.empty();
            }
        };
    }

    @Bean(name={"a2aServerSelfCard"})
    @ConditionalOnMissingBean
    public AgentCard agentCard(A2AServerProperties a2aServerProperties) {
        AgentCard.Builder builder = AgentCard.builder().id(a2aServerProperties.getId()).name(a2aServerProperties.getName()).url(a2aServerProperties.getUrl()).version(a2aServerProperties.getVersion()).description(a2aServerProperties.getDescription());
        if (a2aServerProperties.getProvider() != null) {
            builder.provider(AgentProvider.builder().organization(a2aServerProperties.getProvider().getName()).url(a2aServerProperties.getProvider().getUrl()).build());
        }
        if (a2aServerProperties.getDocumentationUrl() != null) {
            builder.documentationUrl(a2aServerProperties.getDocumentationUrl());
        }
        if (a2aServerProperties.getCapabilities() != null) {
            builder.capabilities(AgentCapabilities.builder().streaming(a2aServerProperties.getCapabilities().isStreaming()).pushNotifications(a2aServerProperties.getCapabilities().isPushNotifications()).stateTransitionHistory(a2aServerProperties.getCapabilities().isStateTransitionHistory()).build());
        }
        if (a2aServerProperties.getAuthentication() != null && a2aServerProperties.getAuthentication().getType() != null) {
            builder.authentication(AgentAuthentication.builder().schemes(List.of(a2aServerProperties.getAuthentication().getType())).build());
        }
        if (a2aServerProperties.getSecuritySchemes() != null && !a2aServerProperties.getSecuritySchemes().isEmpty()) {
            builder.securitySchemes(a2aServerProperties.getSecuritySchemes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SecurityScheme.builder().type(((A2AServerProperties.SecurityScheme)e.getValue()).getType()).build())));
        }
        if (a2aServerProperties.getSecurity() != null && !a2aServerProperties.getSecurity().isEmpty()) {
            builder.security(a2aServerProperties.getSecurity());
        }
        if (a2aServerProperties.getDefaultInputModes() != null && !a2aServerProperties.getDefaultInputModes().isEmpty()) {
            builder.defaultInputModes(a2aServerProperties.getDefaultInputModes());
        }
        if (a2aServerProperties.getDefaultOutputModes() != null && !a2aServerProperties.getDefaultOutputModes().isEmpty()) {
            builder.defaultOutputModes(a2aServerProperties.getDefaultOutputModes());
        }
        if (a2aServerProperties.getSkills() != null && !a2aServerProperties.getSkills().isEmpty()) {
            builder.skills(a2aServerProperties.getSkills().stream().filter(skill -> skill != null && skill.getName() != null).map(skill -> AgentSkill.builder().id(skill.getName()).name(skill.getName()).description(skill.getDescription()).tags(skill.getTags()).examples(skill.getExamples()).inputModes(skill.getInputModes()).outputModes(skill.getOutputModes()).build()).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public A2AServer a2AServer(TaskManager taskManager, AgentExecutor agentExecutor, QueueManager queueManager, AgentCard agentCard) {
        return new DefaultA2AServer(taskManager, agentExecutor, queueManager, agentCard);
    }
}

