/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.agentexecution;

import io.a2a.server.ServerCallContext;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.Part;
import io.a2a.spec.Task;
import io.a2a.spec.TextPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class RequestContext {
    private MessageSendParams params;
    private String taskId;
    private String contextId;
    private Task task;
    private List<Task> relatedTasks;

    public RequestContext(MessageSendParams params, String taskId, String contextId, Task task, List<Task> relatedTasks) throws InvalidParamsError {
        this.params = params;
        this.taskId = taskId;
        this.contextId = contextId;
        this.task = task;
        ArrayList arrayList = this.relatedTasks = relatedTasks == null ? new ArrayList() : relatedTasks;
        if (params != null) {
            if (taskId != null && !taskId.equals(params.message().getTaskId())) {
                throw new InvalidParamsError("bad task id");
            }
            this.checkOrGenerateTaskId();
            if (contextId != null && !contextId.equals(params.message().getContextId())) {
                throw new InvalidParamsError("bad context id");
            }
            this.checkOrGenerateContextId();
        }
    }

    public MessageSendParams getParams() {
        return this.params;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Task getTask() {
        return this.task;
    }

    public List<Task> getRelatedTasks() {
        return Collections.unmodifiableList(this.relatedTasks);
    }

    public Message getMessage() {
        return this.params != null ? this.params.message() : null;
    }

    public MessageSendConfiguration getConfiguration() {
        return this.params != null ? this.params.configuration() : null;
    }

    public String getUserInput(String delimiter) {
        if (this.params == null) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "\n";
        }
        return this.getMessageText(this.params.message(), delimiter);
    }

    public void attachRelatedTask(Task task) {
        this.relatedTasks.add(task);
    }

    private void checkOrGenerateTaskId() {
        if (this.params == null) {
            return;
        }
        if (this.taskId == null && this.params.message().getTaskId() == null) {
            this.params.message().setTaskId(UUID.randomUUID().toString());
        }
        if (this.params.message().getTaskId() != null) {
            this.taskId = this.params.message().getTaskId();
        }
    }

    private void checkOrGenerateContextId() {
        if (this.params == null) {
            return;
        }
        if (this.contextId == null && this.params.message().getContextId() == null) {
            this.params.message().setContextId(UUID.randomUUID().toString());
        }
        if (this.params.message().getContextId() != null) {
            this.contextId = this.params.message().getContextId();
        }
    }

    private String getMessageText(Message message, String delimiter) {
        List<String> textParts = this.getTextParts(message.getParts());
        return String.join((CharSequence)delimiter, textParts);
    }

    private List<String> getTextParts(List<Part<?>> parts) {
        return parts.stream().filter(part -> part.getKind() == Part.Kind.TEXT).map(part -> (TextPart)part).map(TextPart::getText).collect(Collectors.toList());
    }

    public static class Builder {
        private MessageSendParams params;
        private String taskId;
        private String contextId;
        private Task task;
        private List<Task> relatedTasks;
        private ServerCallContext serverCallContext;

        public Builder setParams(MessageSendParams params) {
            this.params = params;
            return this;
        }

        public Builder setTaskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder setContextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder setTask(Task task) {
            this.task = task;
            return this;
        }

        public Builder setRelatedTasks(List<Task> relatedTasks) {
            this.relatedTasks = relatedTasks;
            return this;
        }

        public Builder setServerCallContext(ServerCallContext serverCallContext) {
            this.serverCallContext = serverCallContext;
            return this;
        }

        public MessageSendParams getParams() {
            return this.params;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getContextId() {
            return this.contextId;
        }

        public Task getTask() {
            return this.task;
        }

        public List<Task> getRelatedTasks() {
            return this.relatedTasks;
        }

        public ServerCallContext getServerCallContext() {
            return this.serverCallContext;
        }

        public RequestContext build() {
            return new RequestContext(this.params, this.taskId, this.contextId, this.task, this.relatedTasks);
        }
    }
}

