/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.A2AServerException;
import io.a2a.spec.Artifact;
import io.a2a.spec.Event;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.Message;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class TaskManager {
    private volatile String taskId;
    private volatile String contextId;
    private final TaskStore taskStore;
    private final Message initialMessage;
    private volatile Task currentTask;

    public TaskManager(String taskId, String contextId, TaskStore taskStore, Message initialMessage) {
        Assert.checkNotNullParam((String)"taskStore", (Object)taskStore);
        this.taskId = taskId;
        this.contextId = contextId;
        this.taskStore = taskStore;
        this.initialMessage = initialMessage;
    }

    String getTaskId() {
        return this.taskId;
    }

    String getContextId() {
        return this.contextId;
    }

    public Task getTask() {
        if (this.taskId == null) {
            return null;
        }
        if (this.currentTask != null) {
            return this.currentTask;
        }
        this.currentTask = this.taskStore.get(this.taskId);
        return this.currentTask;
    }

    Task saveTaskEvent(Task task) throws A2AServerException {
        this.checkIdsAndUpdateIfNecessary(task.getId(), task.getContextId());
        return this.saveTask(task);
    }

    Task saveTaskEvent(TaskStatusUpdateEvent event) throws A2AServerException {
        this.checkIdsAndUpdateIfNecessary(event.getTaskId(), event.getContextId());
        Task task = this.ensureTask(event.getTaskId(), event.getContextId());
        Task.Builder builder = new Task.Builder(task).status(event.getStatus());
        if (task.getStatus().message() != null) {
            ArrayList<Message> newHistory = task.getHistory() == null ? new ArrayList<Message>() : new ArrayList(task.getHistory());
            newHistory.add(task.getStatus().message());
            builder.history(newHistory);
        }
        task = builder.build();
        return this.saveTask(task);
    }

    Task saveTaskEvent(TaskArtifactUpdateEvent event) throws A2AServerException {
        this.checkIdsAndUpdateIfNecessary(event.getTaskId(), event.getContextId());
        Task task = this.ensureTask(event.getTaskId(), event.getContextId());
        ArrayList<Artifact> artifacts = task.getArtifacts() == null ? new ArrayList<Artifact>() : new ArrayList(task.getArtifacts());
        Artifact newArtifact = event.getArtifact();
        String artifactId = newArtifact.artifactId();
        boolean appendParts = event.isAppend() != null && event.isAppend() != false;
        Artifact existingArtifact = null;
        int existingArtifactIndex = -1;
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact curr = (Artifact)artifacts.get(i);
            if (curr.artifactId() == null || !curr.artifactId().equals(artifactId)) continue;
            existingArtifact = curr;
            existingArtifactIndex = i;
            break;
        }
        if (!appendParts) {
            if (existingArtifactIndex >= 0) {
                artifacts.set(existingArtifactIndex, newArtifact);
            } else {
                artifacts.add(newArtifact);
            }
        } else if (existingArtifact != null) {
            ArrayList parts = new ArrayList(existingArtifact.parts());
            parts.addAll(newArtifact.parts());
            Artifact updated = new Artifact.Builder(existingArtifact).parts(parts).build();
            artifacts.set(existingArtifactIndex, updated);
        }
        task = new Task.Builder(task).artifacts(artifacts).build();
        return this.saveTask(task);
    }

    public Event process(Event event) throws A2AServerException {
        if (event instanceof Task) {
            Task task = (Task)event;
            this.saveTask(task);
        } else if (event instanceof TaskStatusUpdateEvent) {
            TaskStatusUpdateEvent taskStatusUpdateEvent = (TaskStatusUpdateEvent)event;
            this.saveTaskEvent(taskStatusUpdateEvent);
        } else if (event instanceof TaskArtifactUpdateEvent) {
            TaskArtifactUpdateEvent taskArtifactUpdateEvent = (TaskArtifactUpdateEvent)event;
            this.saveTaskEvent(taskArtifactUpdateEvent);
        }
        return event;
    }

    public Task updateWithMessage(Message message, Task task) {
        ArrayList<Message> history;
        ArrayList<Object> arrayList = history = task.getHistory() == null ? new ArrayList<Message>() : new ArrayList(task.getHistory());
        if (task.getStatus().message() != null) {
            history.add(task.getStatus().message());
        }
        history.add(message);
        task = new Task.Builder(task).history(history).build();
        this.saveTask(task);
        return task;
    }

    private void checkIdsAndUpdateIfNecessary(String eventTaskId, String eventContextId) throws A2AServerException {
        if (this.taskId != null && !eventTaskId.equals(this.taskId)) {
            throw new A2AServerException("Invalid task id", (Throwable)new InvalidParamsError(String.format("Task in event doesn't match TaskManager ", new Object[0])));
        }
        if (this.taskId == null) {
            this.taskId = eventTaskId;
        }
        if (this.contextId == null) {
            this.contextId = eventContextId;
        }
    }

    private Task ensureTask(String eventTaskId, String eventContextId) {
        Task task = this.currentTask;
        if (task != null) {
            return task;
        }
        task = this.taskStore.get(this.taskId);
        if (task == null) {
            task = this.createTask(eventTaskId, eventContextId);
            this.saveTask(task);
        }
        return task;
    }

    private Task createTask(String taskId, String contextId) {
        List<Message> history = this.initialMessage != null ? List.of(this.initialMessage) : null;
        return new Task.Builder().id(taskId).contextId(contextId).status(new TaskStatus(TaskState.SUBMITTED)).history(history).build();
    }

    private Task saveTask(Task task) {
        this.taskStore.save(task);
        if (this.taskId == null) {
            this.taskId = task.getId();
            this.contextId = task.getContextId();
        }
        this.currentTask = task;
        return this.currentTask;
    }
}

