/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.core.page.AXNode;
import com.ruiyun.jvppeteer.core.page.ElementHandle;
import com.ruiyun.jvppeteer.protocol.accessbility.SerializedAXNode;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Accessibility {
    private final CDPSession client;

    public Accessibility(CDPSession client) {
        this.client = client;
    }

    public SerializedAXNode snapshot(boolean interestingOnly, ElementHandle root) throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        String finalBackendNodeId;
        AXNode defaultRoot;
        JsonNode nodes = this.client.send("Accessibility.getFullAXTree", null, false);
        String backendNodeId = null;
        if (root != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objectId", root.getRemoteObject().getObjectId());
            JsonNode node = this.client.send("DOM.describeNode", params, true);
            backendNodeId = node.get("backendNodeId").asText();
        }
        Iterator elements = nodes.elements();
        ArrayList<com.ruiyun.jvppeteer.protocol.accessbility.AXNode> payloads = new ArrayList<com.ruiyun.jvppeteer.protocol.accessbility.AXNode>();
        while (elements.hasNext()) {
            payloads.add((com.ruiyun.jvppeteer.protocol.accessbility.AXNode)Constant.OBJECTMAPPER.treeToValue((TreeNode)elements.next(), com.ruiyun.jvppeteer.protocol.accessbility.AXNode.class));
        }
        AXNode needle = defaultRoot = AXNode.createTree(payloads);
        if (StringUtil.isNotEmpty(backendNodeId) && (needle = defaultRoot.find(arg_0 -> Accessibility.lambda$snapshot$0(finalBackendNodeId = backendNodeId, arg_0))) == null) {
            return null;
        }
        if (!interestingOnly) {
            return this.serializeTree(needle, null).get(0);
        }
        HashSet<AXNode> interestingNodes = new HashSet<AXNode>();
        this.collectInterestingNodes(interestingNodes, defaultRoot, false);
        if (!interestingNodes.contains(needle)) {
            return null;
        }
        return this.serializeTree(needle, interestingNodes).get(0);
    }

    private void collectInterestingNodes(Set<AXNode> collection, AXNode node, boolean insideControl) {
        if (node.isInteresting(insideControl)) {
            collection.add(node);
        }
        if (node.isLeafNode()) {
            return;
        }
        insideControl = insideControl || node.isControl();
        for (AXNode child : node.getChildren()) {
            this.collectInterestingNodes(collection, child, insideControl);
        }
    }

    public List<SerializedAXNode> serializeTree(AXNode node, Set<AXNode> whitelistedNodes) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        ArrayList<SerializedAXNode> children = new ArrayList<SerializedAXNode>();
        for (AXNode child : node.getChildren()) {
            children.addAll(this.serializeTree(child, whitelistedNodes));
        }
        if (ValidateUtil.isNotEmpty(whitelistedNodes) && !whitelistedNodes.contains(node)) {
            return children;
        }
        SerializedAXNode serializedNode = node.serialize();
        if (ValidateUtil.isNotEmpty(children)) {
            serializedNode.setChildren(children);
        }
        ArrayList<SerializedAXNode> result = new ArrayList<SerializedAXNode>();
        result.add(serializedNode);
        return result;
    }

    private static /* synthetic */ boolean lambda$snapshot$0(String finalBackendNodeId, AXNode node) {
        return finalBackendNodeId.equals(node.getPayload().getBackendDOMNodeId() + "");
    }
}

