/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.api;

import cn.jiguang.sdk.bean.admin.AppCreateParam;
import cn.jiguang.sdk.bean.admin.AppCreateResult;
import cn.jiguang.sdk.bean.admin.AppDeleteResult;
import cn.jiguang.sdk.bean.admin.CertificateUploadParam;
import cn.jiguang.sdk.bean.admin.CertificateUploadResult;
import cn.jiguang.sdk.client.AdminClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.net.Proxy;
import lombok.NonNull;
import okhttp3.OkHttpClient;

public class AdminApi {
    private final AdminClient adminClient;

    protected AdminApi(@NonNull AdminClient adminClient) {
        if (adminClient == null) {
            throw new NullPointerException("adminClient is marked non-null but is null");
        }
        this.adminClient = adminClient;
    }

    public AppCreateResult createApp(@NonNull AppCreateParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.adminClient.createApp(param);
    }

    public AppDeleteResult deleteApp(@NonNull String appKey) {
        if (appKey == null) {
            throw new NullPointerException("appKey is marked non-null but is null");
        }
        return this.adminClient.deleteApp(appKey);
    }

    public CertificateUploadResult uploadCertificate(@NonNull String appKey, @NonNull CertificateUploadParam param) {
        if (appKey == null) {
            throw new NullPointerException("appKey is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.adminClient.uploadCertificate(appKey, param);
    }

    public static class Builder {
        private String host = "https://admin.jpush.cn";
        private Proxy proxy;
        private String devKey;
        private String devSecret;
        private Logger.Level loggerLevel = Logger.Level.BASIC;

        public Builder setHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder setProxy(@NonNull Proxy proxy) {
            if (proxy == null) {
                throw new NullPointerException("proxy is marked non-null but is null");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder setDevKey(@NonNull String devKey) {
            if (devKey == null) {
                throw new NullPointerException("devKey is marked non-null but is null");
            }
            this.devKey = devKey;
            return this;
        }

        public Builder setDevSecret(@NonNull String devSecret) {
            if (devSecret == null) {
                throw new NullPointerException("devSecret is marked non-null but is null");
            }
            this.devSecret = devSecret;
            return this;
        }

        public Builder setLoggerLevel(@NonNull Logger.Level loggerLevel) {
            if (loggerLevel == null) {
                throw new NullPointerException("loggerLevel is marked non-null but is null");
            }
            this.loggerLevel = loggerLevel;
            return this;
        }

        public AdminApi build() {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            if (this.proxy != null) {
                delegateBuilder.proxy(this.proxy);
            }
            AdminClient adminClient = (AdminClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(this.devKey, this.devSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(this.loggerLevel).target(AdminClient.class, this.host);
            return new AdminApi(adminClient);
        }
    }
}

