/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.api;

import cn.jiguang.sdk.bean.report.MessageDetailGetResult;
import cn.jiguang.sdk.bean.report.MessageStatusGetParam;
import cn.jiguang.sdk.bean.report.MessageStatusGetResult;
import cn.jiguang.sdk.bean.report.ReceivedDetailGetResult;
import cn.jiguang.sdk.bean.report.UserDetailGetResult;
import cn.jiguang.sdk.client.ReportClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.net.Proxy;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import okhttp3.OkHttpClient;

public class ReportApi {
    private final ReportClient reportClient;

    protected ReportApi(@NonNull ReportClient reportClient) {
        if (reportClient == null) {
            throw new NullPointerException("reportClient is marked non-null but is null");
        }
        this.reportClient = reportClient;
    }

    public List<ReceivedDetailGetResult> getReceivedDetail(@NonNull List<String> msgIds) {
        if (msgIds == null) {
            throw new NullPointerException("msgIds is marked non-null but is null");
        }
        return this.reportClient.getReceivedDetail(String.join((CharSequence)",", msgIds));
    }

    public Map<String, MessageStatusGetResult> getMessageStatus(@NonNull MessageStatusGetParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.reportClient.getMessageStatus(param);
    }

    public List<MessageDetailGetResult> getMessageDetail(@NonNull List<String> msgIds) {
        if (msgIds == null) {
            throw new NullPointerException("msgIds is marked non-null but is null");
        }
        return this.reportClient.getMessageDetail(String.join((CharSequence)",", msgIds));
    }

    public UserDetailGetResult getUserDetail(@NonNull LocalDate startDate, @NonNull int duration) {
        if (startDate == null) {
            throw new NullPointerException("startDate is marked non-null but is null");
        }
        return this.reportClient.getUserDetail(startDate, duration);
    }

    public static class Builder {
        private String host = "https://report.jpush.cn";
        private Proxy proxy;
        private String appKey;
        private String masterSecret;
        private Logger.Level loggerLevel = Logger.Level.BASIC;

        public Builder setHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder setProxy(@NonNull Proxy proxy) {
            if (proxy == null) {
                throw new NullPointerException("proxy is marked non-null but is null");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder setAppKey(@NonNull String appKey) {
            if (appKey == null) {
                throw new NullPointerException("appKey is marked non-null but is null");
            }
            this.appKey = appKey;
            return this;
        }

        public Builder setMasterSecret(@NonNull String masterSecret) {
            if (masterSecret == null) {
                throw new NullPointerException("masterSecret is marked non-null but is null");
            }
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder setLoggerLevel(@NonNull Logger.Level loggerLevel) {
            if (loggerLevel == null) {
                throw new NullPointerException("loggerLevel is marked non-null but is null");
            }
            this.loggerLevel = loggerLevel;
            return this;
        }

        public ReportApi build() {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            if (this.proxy != null) {
                delegateBuilder.proxy(this.proxy);
            }
            ReportClient reportClient = (ReportClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(this.appKey, this.masterSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(this.loggerLevel).target(ReportClient.class, this.host);
            return new ReportApi(reportClient);
        }
    }
}

