/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.bean.push;

import cn.jiguang.sdk.bean.push.PushSendResult;
import cn.jiguang.sdk.exception.ApiErrorException;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;

public class GroupPushSendResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ApiErrorException.ApiError.Error> errors = new HashMap<String, ApiErrorException.ApiError.Error>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, PushSendResult> successes = new HashMap<String, PushSendResult>();
    @JsonProperty(value="group_msgid")
    private String groupMessageId;

    @JsonAnySetter
    public void handleUnknown(String key, JsonNode value) {
        if (key.equals("group_msgid")) {
            this.setGroupMessageId(value.asText());
        } else if (value.has("error")) {
            ApiErrorException.ApiError.Error errorDetail = new ApiErrorException.ApiError.Error();
            errorDetail.setCode(value.get("error").get("code").asInt());
            errorDetail.setMessage(value.get("error").get("message").asText());
            this.errors.put(key, errorDetail);
        } else if (value.has("msg_id")) {
            PushSendResult successDetail = new PushSendResult();
            successDetail.setMessageId(value.get("msg_id").asText());
            successDetail.setSendNo(value.get("sendno").asText());
            this.successes.put(key, successDetail);
        }
    }

    public Map<String, ApiErrorException.ApiError.Error> getErrors() {
        return this.errors;
    }

    public Map<String, PushSendResult> getSuccesses() {
        return this.successes;
    }

    public String getGroupMessageId() {
        return this.groupMessageId;
    }

    public void setErrors(Map<String, ApiErrorException.ApiError.Error> errors) {
        this.errors = errors;
    }

    public void setSuccesses(Map<String, PushSendResult> successes) {
        this.successes = successes;
    }

    @JsonProperty(value="group_msgid")
    public void setGroupMessageId(String groupMessageId) {
        this.groupMessageId = groupMessageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupPushSendResult)) {
            return false;
        }
        GroupPushSendResult other = (GroupPushSendResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ApiErrorException.ApiError.Error> this$errors = this.getErrors();
        Map<String, ApiErrorException.ApiError.Error> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        Map<String, PushSendResult> this$successes = this.getSuccesses();
        Map<String, PushSendResult> other$successes = other.getSuccesses();
        if (this$successes == null ? other$successes != null : !((Object)this$successes).equals(other$successes)) {
            return false;
        }
        String this$groupMessageId = this.getGroupMessageId();
        String other$groupMessageId = other.getGroupMessageId();
        return !(this$groupMessageId == null ? other$groupMessageId != null : !this$groupMessageId.equals(other$groupMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupPushSendResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ApiErrorException.ApiError.Error> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        Map<String, PushSendResult> $successes = this.getSuccesses();
        result = result * 59 + ($successes == null ? 43 : ((Object)$successes).hashCode());
        String $groupMessageId = this.getGroupMessageId();
        result = result * 59 + ($groupMessageId == null ? 43 : $groupMessageId.hashCode());
        return result;
    }

    public String toString() {
        return "GroupPushSendResult(errors=" + this.getErrors() + ", successes=" + this.getSuccesses() + ", groupMessageId=" + this.getGroupMessageId() + ")";
    }
}

