/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.codec;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonEncoder;
import java.lang.reflect.Type;
import java.util.Collection;

public class ApiEncoder
implements Encoder {
    private final FormEncoder formEncoder = new FormEncoder();
    private final JacksonEncoder jacksonEncoder;

    public ApiEncoder() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        this.jacksonEncoder = new JacksonEncoder(objectMapper);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        String contentType = ((Collection)template.headers().get("Content-Type")).stream().findFirst().orElse(null);
        if (contentType == null) {
            return;
        }
        if (contentType.startsWith("application/json")) {
            this.jacksonEncoder.encode(object, bodyType, template);
            return;
        }
        if (contentType.startsWith("multipart/form-data")) {
            this.formEncoder.encode(object, bodyType, template);
            return;
        }
    }
}

