/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.apache.commons.lang3.StringUtils;

public class BoundaryEventXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return BoundaryEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "boundaryEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        EventDefinition eventDef;
        String cancelActivity;
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        BpmnXMLUtil.addXMLLocation(boundaryEvent, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "cancelActivity")) && "false".equalsIgnoreCase(cancelActivity = xtr.getAttributeValue(null, "cancelActivity"))) {
            boundaryEvent.setCancelActivity(false);
        }
        boundaryEvent.setAttachedToRefId(xtr.getAttributeValue(null, "attachedToRef"));
        this.parseChildElements(this.getXMLElementName(), boundaryEvent, model, xtr);
        if (boundaryEvent.getEventDefinitions().size() == 1 && (eventDef = boundaryEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition) {
            boundaryEvent.setCancelActivity(false);
        }
        return boundaryEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        EventDefinition eventDef;
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        if (boundaryEvent.getAttachedToRef() != null) {
            this.writeDefaultAttribute("attachedToRef", boundaryEvent.getAttachedToRef().getId(), xtw);
        }
        if (boundaryEvent.getEventDefinitions().size() == 1 && !((eventDef = boundaryEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition)) {
            this.writeDefaultAttribute("cancelActivity", String.valueOf(boundaryEvent.isCancelActivity()).toLowerCase(), xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        this.writeEventDefinitions(boundaryEvent, boundaryEvent.getEventDefinitions(), model, xtw);
    }
}

