/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BooleanDataObject;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DateDataObject;
import org.activiti.bpmn.model.DoubleDataObject;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.IntegerDataObject;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.LongDataObject;
import org.activiti.bpmn.model.StringDataObject;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;

public class ValuedDataObjectXMLConverter
extends BaseBpmnXMLConverter {
    private final Pattern xmlChars = Pattern.compile("[<>&]");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected boolean didWriteExtensionStartElement = false;

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ValuedDataObject.class;
    }

    @Override
    protected String getXMLElementName() {
        return "dataObject";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        ValuedDataObject dataObject = null;
        ItemDefinition itemSubjectRef = new ItemDefinition();
        String structureRef = xtr.getAttributeValue(null, "itemSubjectRef");
        if (StringUtils.isNotEmpty((CharSequence)structureRef) && structureRef.contains(":")) {
            String dataType = structureRef.substring(structureRef.indexOf(58) + 1);
            if (dataType.equals("string")) {
                dataObject = new StringDataObject();
            } else if (dataType.equals("int")) {
                dataObject = new IntegerDataObject();
            } else if (dataType.equals("long")) {
                dataObject = new LongDataObject();
            } else if (dataType.equals("double")) {
                dataObject = new DoubleDataObject();
            } else if (dataType.equals("boolean")) {
                dataObject = new BooleanDataObject();
            } else if (dataType.equals("datetime")) {
                dataObject = new DateDataObject();
            } else {
                LOGGER.error("Error converting {}, invalid data type: " + dataType, (Object)xtr.getAttributeValue(null, "name"));
            }
        } else {
            dataObject = new StringDataObject();
            structureRef = "xsd:string";
        }
        if (dataObject != null) {
            dataObject.setId(xtr.getAttributeValue(null, "id"));
            dataObject.setName(xtr.getAttributeValue(null, "name"));
            BpmnXMLUtil.addXMLLocation(dataObject, xtr);
            itemSubjectRef.setStructureRef(structureRef);
            dataObject.setItemSubjectRef(itemSubjectRef);
            this.parseChildElements(this.getXMLElementName(), dataObject, model, xtr);
            List<ExtensionElement> valuesElement = dataObject.getExtensionElements().get("value");
            if (valuesElement != null && !valuesElement.isEmpty()) {
                ExtensionElement valueElement = valuesElement.get(0);
                if (StringUtils.isNotEmpty((CharSequence)valueElement.getElementText())) {
                    if (dataObject instanceof DateDataObject) {
                        try {
                            dataObject.setValue(this.sdf.parse(valueElement.getElementText()));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error converting {}", (Object)dataObject.getName(), (Object)e.getMessage());
                        }
                    } else {
                        dataObject.setValue(valueElement.getElementText());
                    }
                }
                dataObject.getExtensionElements().remove("value");
            }
        }
        return dataObject;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (dataObject.getItemSubjectRef() != null && StringUtils.isNotEmpty((CharSequence)dataObject.getItemSubjectRef().getStructureRef())) {
            this.writeDefaultAttribute("itemSubjectRef", dataObject.getItemSubjectRef().getStructureRef(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (StringUtils.isNotEmpty((CharSequence)dataObject.getId()) && dataObject.getValue() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", "value", "http://activiti.org/bpmn");
            if (dataObject.getValue() != null) {
                String value = null;
                value = dataObject instanceof DateDataObject ? this.sdf.format(dataObject.getValue()) : dataObject.getValue().toString();
                if (dataObject instanceof StringDataObject && this.xmlChars.matcher(value).find()) {
                    xtw.writeCData(value);
                } else {
                    xtw.writeCharacters(value);
                }
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

