/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.HasExtensionAttributes;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseElement
implements HasExtensionAttributes {
    protected String id;
    protected int xmlRowNumber;
    protected int xmlColumnNumber;
    protected Map<String, List<ExtensionElement>> extensionElements = new LinkedHashMap<String, List<ExtensionElement>>();
    protected Map<String, List<ExtensionAttribute>> attributes = new LinkedHashMap<String, List<ExtensionAttribute>>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getXmlRowNumber() {
        return this.xmlRowNumber;
    }

    public void setXmlRowNumber(int xmlRowNumber) {
        this.xmlRowNumber = xmlRowNumber;
    }

    public int getXmlColumnNumber() {
        return this.xmlColumnNumber;
    }

    public void setXmlColumnNumber(int xmlColumnNumber) {
        this.xmlColumnNumber = xmlColumnNumber;
    }

    public Map<String, List<ExtensionElement>> getExtensionElements() {
        return this.extensionElements;
    }

    public void addExtensionElement(ExtensionElement extensionElement) {
        if (extensionElement != null && StringUtils.isNotEmpty((CharSequence)extensionElement.getName())) {
            ArrayList elementList = null;
            if (!this.extensionElements.containsKey(extensionElement.getName())) {
                elementList = new ArrayList();
                this.extensionElements.put(extensionElement.getName(), elementList);
            }
            this.extensionElements.get(extensionElement.getName()).add(extensionElement);
        }
    }

    public void setExtensionElements(Map<String, List<ExtensionElement>> extensionElements) {
        this.extensionElements = extensionElements;
    }

    @Override
    public Map<String, List<ExtensionAttribute>> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        List<ExtensionAttribute> attributes = this.getAttributes().get(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (ExtensionAttribute attribute : attributes) {
                if ((namespace != null || attribute.getNamespace() != null) && (namespace == null || !namespace.equals(attribute.getNamespace()))) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    @Override
    public void addAttribute(ExtensionAttribute attribute) {
        if (attribute != null && StringUtils.isNotEmpty((CharSequence)attribute.getName())) {
            ArrayList attributeList = null;
            if (!this.attributes.containsKey(attribute.getName())) {
                attributeList = new ArrayList();
                this.attributes.put(attribute.getName(), attributeList);
            }
            this.attributes.get(attribute.getName()).add(attribute);
        }
    }

    @Override
    public void setAttributes(Map<String, List<ExtensionAttribute>> attributes) {
        this.attributes = attributes;
    }

    public void setValues(BaseElement otherElement) {
        this.setId(otherElement.getId());
        this.extensionElements = new LinkedHashMap<String, List<ExtensionElement>>();
        if (otherElement.getExtensionElements() != null && !otherElement.getExtensionElements().isEmpty()) {
            for (String key : otherElement.getExtensionElements().keySet()) {
                List<ExtensionElement> otherElementList = otherElement.getExtensionElements().get(key);
                if (otherElementList == null || otherElementList.isEmpty()) continue;
                ArrayList<ExtensionElement> elementList = new ArrayList<ExtensionElement>();
                for (ExtensionElement extensionElement : otherElementList) {
                    elementList.add(extensionElement.clone());
                }
                this.extensionElements.put(key, elementList);
            }
        }
        this.attributes = new LinkedHashMap<String, List<ExtensionAttribute>>();
        if (otherElement.getAttributes() != null && !otherElement.getAttributes().isEmpty()) {
            for (String key : otherElement.getAttributes().keySet()) {
                List<ExtensionAttribute> otherAttributeList = otherElement.getAttributes().get(key);
                if (otherAttributeList == null || otherAttributeList.isEmpty()) continue;
                ArrayList<ExtensionAttribute> attributeList = new ArrayList<ExtensionAttribute>();
                for (ExtensionAttribute extensionAttribute : otherAttributeList) {
                    attributeList.add(extensionAttribute.clone());
                }
                this.attributes.put(key, attributeList);
            }
        }
    }

    public abstract BaseElement clone();
}

