/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.joda.time.DateTime;

public class TimerDeclarationImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected Expression endDateExpression;
    protected Expression calendarNameExpression;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration = null;
    protected String repeat;
    protected boolean exclusive = true;
    protected int retries = 3;
    protected boolean isInterruptingTimer;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType, Expression endDateExpression, Expression calendarNameExpression) {
        this(expression, type, jobHandlerType);
        this.endDateExpression = endDateExpression;
        this.calendarNameExpression = calendarNameExpression;
    }

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
        this.description = expression;
        this.type = type;
    }

    public Expression getDescription() {
        return this.description;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public boolean isInterruptingTimer() {
        return this.isInterruptingTimer;
    }

    public void setInterruptingTimer(boolean isInterruptingTimer) {
        this.isInterruptingTimer = isInterruptingTimer;
    }

    public TimerEntity prepareTimerEntity(ExecutionEntity executionEntity) {
        Object dueDateValue;
        VariableScope scopeForExpression = executionEntity;
        if (scopeForExpression == null) {
            scopeForExpression = NoExecutionVariableScope.getSharedInstance();
        }
        String calendarNameValue = this.type.calendarName;
        if (this.calendarNameExpression != null) {
            calendarNameValue = (String)this.calendarNameExpression.getValue(scopeForExpression);
        }
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(calendarNameValue);
        if (this.description == null) {
            throw new ActivitiIllegalArgumentException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time");
        }
        String endDateString = null;
        String dueDateString = null;
        Date duedate = null;
        Date endDate = null;
        if (this.endDateExpression != null && !(scopeForExpression instanceof NoExecutionVariableScope)) {
            Object endDateValue = this.endDateExpression.getValue(scopeForExpression);
            if (endDateValue instanceof String) {
                endDateString = (String)endDateValue;
            } else if (endDateValue instanceof Date) {
                endDate = (Date)endDateValue;
            } else if (endDateValue instanceof DateTime) {
                duedate = ((DateTime)endDateValue).toDate();
            } else {
                throw new ActivitiException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
            }
            if (endDate == null) {
                endDate = businessCalendar.resolveEndDate(endDateString);
            }
        }
        if ((dueDateValue = this.description.getValue(scopeForExpression)) instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else if (dueDateValue instanceof DateTime) {
            duedate = ((DateTime)dueDateValue).toDate();
        } else if (dueDateValue != null) {
            throw new ActivitiException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null && dueDateString != null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerEntity timer = null;
        if (duedate != null) {
            timer = new TimerEntity(this);
            timer.setDuedate(duedate);
            timer.setEndDate(endDate);
            if (executionEntity != null) {
                timer.setExecution(executionEntity);
                timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
                timer.setProcessInstanceId(executionEntity.getProcessInstanceId());
                if (executionEntity != null && executionEntity.getTenantId() != null) {
                    timer.setTenantId(executionEntity.getTenantId());
                }
            }
            if (this.type == TimerDeclarationType.CYCLE) {
                boolean repeat;
                boolean bl = repeat = !this.isInterruptingTimer;
                if ("timer-intermediate-transition".equals(this.jobHandlerType)) {
                    repeat = false;
                    if (endDate != null) {
                        long endDateMiliss = endDate.getTime();
                        long dueDateMiliss = duedate.getTime();
                        long dueDate = Math.min(endDateMiliss, dueDateMiliss);
                        timer.setDuedate(new Date(dueDate));
                    }
                }
                if (repeat) {
                    String prepared = this.prepareRepeat(dueDateString);
                    timer.setRepeat(prepared);
                }
            }
        }
        return timer;
    }

    private String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(Context.getProcessEngineConfiguration().getClock().getCurrentTime()) + "/");
        }
        return dueDate;
    }
}

