/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class UserTaskValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List<UserTask> userTasks = process.findFlowElementsOfType(UserTask.class);
        for (UserTask userTask : userTasks) {
            if (userTask.getTaskListeners() == null) continue;
            for (ActivitiListener listener : userTask.getTaskListeners()) {
                if (listener.getImplementation() != null && listener.getImplementationType() != null) continue;
                this.addError(errors, "activiti-usertask-listener-implementation-missing", process, userTask, "Element 'class' or 'expression' is mandatory on executionListener");
            }
        }
    }
}

