/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.aspect;

import com.alibaba.fastjson2.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.openoa.base.entity.MethodReplayEntity;
import org.openoa.base.interf.MethodReplay;
import org.openoa.base.mapper.MethodReplayMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Aspect
@Component
public class ExceptionLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(ExceptionLoggingAspect.class);
    @Autowired
    private MethodReplayMapper methodReplayMapper;
    @Value(value="${methodreplay.on:true}")
    private boolean methodReplayOn;

    @Around(value="@annotation(methodReplay)")
    public Object aroundMethodExecution(ProceedingJoinPoint joinPoint, MethodReplay methodReplay) throws Throwable {
        Object result;
        try {
            result = joinPoint.proceed();
        }
        catch (Exception e) {
            if (this.methodReplayOn) {
                String className = joinPoint.getTarget().getClass().getName();
                if (Proxy.isProxyClass(joinPoint.getTarget().getClass())) {
                    Class[] classes = AopProxyUtils.proxiedUserInterfaces((Object)joinPoint.getTarget());
                    if (classes.length > 0) {
                        className = classes[0].getName();
                    }
                } else if (AopUtils.isCglibProxy((Object)joinPoint.getTarget())) {
                    className = ClassUtils.getUserClass((Object)joinPoint.getTarget()).getName();
                }
                String methodName = joinPoint.getSignature().getName();
                MethodSignature signature = (MethodSignature)joinPoint.getSignature();
                Method method = signature.getMethod();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] args = joinPoint.getArgs();
                log.info("MethodReplay\u63a5\u53d7\u5230\u5f02\u5e38,Class name:{},Method name:{},parameterTypes:{}, Arguments:{}", new Object[]{className, methodName, JSON.toJSONString(parameterTypes), JSON.toJSONString((Object)args)});
                MethodReplayEntity methodReplayEntity = new MethodReplayEntity();
                methodReplayEntity.setProjectName("antFlow");
                methodReplayEntity.setClassName(className);
                methodReplayEntity.setMethodName(methodName);
                methodReplayEntity.setParamType(JSON.toJSONString(parameterTypes));
                methodReplayEntity.setArgs(JSON.toJSONString((Object)args));
                String message = e.getMessage();
                if (message.length() > 100) {
                    message = message.substring(0, 100);
                }
                methodReplayEntity.setErrorMsg(message);
                methodReplayEntity.setAlreadyReplayTimes(0);
                methodReplayEntity.setMaxReplayTimes(methodReplay.maxReplayTimes());
                String sum = "antFlow" + className + methodName + methodReplayEntity.getParamType() + methodReplayEntity.getArgs();
                CRC32 crc32 = new CRC32();
                crc32.update(sum.getBytes(StandardCharsets.UTF_8));
                methodReplayEntity.setId(crc32.getValue());
                MethodReplayEntity exist = this.methodReplayMapper.selectById(methodReplayEntity);
                if (exist == null) {
                    this.methodReplayMapper.insert(methodReplayEntity);
                }
            }
            throw e;
        }
        return result;
    }
}

