/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.service;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.openoa.base.mapper.UserMapper;
import org.openoa.base.service.AfUserService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="afUserService")
public class UserServiceImpl
implements AfUserService {
    @Autowired
    UserMapper userMapper;

    @Override
    public List<BaseIdTranStruVo> queryByNameFuzzy(String userName) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByNameFuzzy(userName);
        return users;
    }

    @Override
    public List<BaseIdTranStruVo> queryCompanyByNameFuzzy(String companyName) {
        List<BaseIdTranStruVo> baseIdTranStruVos = this.userMapper.queryCompanyByNameFuzzy(companyName);
        return baseIdTranStruVos;
    }

    @Override
    public List<BaseIdTranStruVo> queryUserByIds(Collection<String> userIds) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByIds(userIds);
        return users;
    }

    @Override
    public BaseIdTranStruVo getById(String id) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(users)) {
            return new BaseIdTranStruVo();
        }
        return users.get(0);
    }

    @Override
    public List<BaseIdTranStruVo> queryLeadersByEmployeeIdAndTier(String employeeId, Integer tier) {
        List<BaseIdTranStruVo> users = this.userMapper.getLevelLeadersByEmployeeIdAndTier(employeeId, tier);
        return users;
    }

    @Override
    public List<BaseIdTranStruVo> queryLeadersByEmployeeIdAndGrade(String employeeId, Integer grade) {
        List<BaseIdTranStruVo> users = this.userMapper.getLevelLeadersByEmployeeIdAndEndGrade(employeeId, grade);
        return users;
    }

    @Override
    public BaseIdTranStruVo queryLeaderByEmployeeIdAndLevel(String employeeId, Integer level) {
        return this.userMapper.getLeaderByLeventDepartment(employeeId, level);
    }

    @Override
    public BaseIdTranStruVo queryEmployeeHrpbByEmployeeId(String employeeId) {
        BaseIdTranStruVo baseIdTranStruVo = this.userMapper.getHrpbByEmployeeId(employeeId);
        return baseIdTranStruVo;
    }

    @Override
    public BaseIdTranStruVo queryEmployeeDirectLeaderById(String employeeId) {
        BaseIdTranStruVo baseIdTranStruVo = this.userMapper.getDirectLeaderByEmployeeId(employeeId);
        return baseIdTranStruVo;
    }
}

