/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import com.google.common.hash.Hashing;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AFNumberUtil {
    private static final char[] BASE62_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int BASE = BASE62_CHARS.length;

    public static String encodeLong(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Number must be non-negative.");
        }
        StringBuilder encoded = new StringBuilder();
        do {
            int remainder = (int)(number % (long)BASE);
            encoded.append(BASE62_CHARS[remainder]);
        } while ((number /= (long)BASE) > 0L);
        return encoded.reverse().toString();
    }

    public static long decodeLong(String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            throw new IllegalArgumentException("Encoded string cannot be null or empty.");
        }
        long number = 0L;
        for (char c : encoded.toCharArray()) {
            int value = AFNumberUtil.charToValue(c);
            number = number * (long)BASE + (long)value;
        }
        return number;
    }

    public static String shortBusinessId(String businessId) {
        if (businessId == null) {
            return null;
        }
        return businessId.length() > 20 ? AFNumberUtil.generateShortHash(businessId) : businessId;
    }

    public static String generateShortHash(String input) {
        long murmurHash = Hashing.murmur3_128().hashString((CharSequence)input, StandardCharsets.UTF_8).asLong();
        murmurHash = murmurHash < 0L ? -murmurHash : murmurHash;
        return AFNumberUtil.encodeLong(murmurHash);
    }

    public static String md5ToBase62(String input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Bytes = md.digest(input.getBytes());
        BigInteger bigInt = new BigInteger(1, md5Bytes);
        StringBuilder base62 = new StringBuilder();
        while (bigInt.compareTo(BigInteger.ZERO) > 0) {
            int remainder = bigInt.mod(BigInteger.valueOf(62L)).intValue();
            base62.append(BASE62_CHARS[remainder]);
            bigInt = bigInt.divide(BigInteger.valueOf(62L));
        }
        return base62.reverse().toString();
    }

    private static int charToValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 36;
        }
        throw new IllegalArgumentException("Invalid character in encoded string: " + c);
    }
}

