/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.List;
import java.util.Map;
import org.openoa.base.vo.BpmnNodeVo;
import org.springframework.util.CollectionUtils;

public class AfNodeUtils {
    public static BpmnNodeVo getNextNodeOfTypeRecursively(String nodeId, List<Integer> types, Map<String, BpmnNodeVo> mapNodes, boolean includeDeduplicated) {
        if (CollectionUtils.isEmpty(types)) {
            return null;
        }
        if (nodeId == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(mapNodes)) {
            return null;
        }
        BpmnNodeVo node = mapNodes.get(nodeId);
        if (types.contains(node.getNodeType()) && !includeDeduplicated && node.getParams().getIsNodeDeduplication() == 0) {
            return node;
        }
        if (node.getParams().getNodeTo() != null) {
            return AfNodeUtils.getNextNodeOfTypeRecursively(node.getParams().getNodeTo(), types, mapNodes, includeDeduplicated);
        }
        return null;
    }

    public static BpmnNodeVo getNeareastPrevNodeOfTypeRecursively(String nodeId, List<Integer> types, Map<String, BpmnNodeVo> mapNodes, boolean includeDeduplicated) {
        if (CollectionUtils.isEmpty(types)) {
            return null;
        }
        if (nodeId == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(mapNodes)) {
            return null;
        }
        BpmnNodeVo node = mapNodes.get(nodeId);
        String nodeFrom = node.getNodeFrom();
        BpmnNodeVo fromNode = mapNodes.get(nodeFrom);
        if (types.contains(fromNode.getNodeType()) && !includeDeduplicated && node.getParams().getIsNodeDeduplication() == 0) {
            return fromNode;
        }
        if (node.getParams().getNodeTo() != null) {
            return AfNodeUtils.getNeareastPrevNodeOfTypeRecursively(node.getParams().getNodeTo(), types, mapNodes, includeDeduplicated);
        }
        return node;
    }
}

