/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.util.NetworkUtil;
import org.openoa.base.util.ShortUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class MDCLogUtil {
    private static final Logger log = LoggerFactory.getLogger(MDCLogUtil.class);

    public static String getLogIdBydefault() {
        return MDC.get((String)"ruid");
    }

    public static String getLogId() {
        String logId = "";
        try {
            logId = MDC.get((String)"ruid");
        }
        catch (Exception e) {
            log.error("error occur while acquiring logid ", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)logId)) {
            return MDCLogUtil.setLogId();
        }
        return logId;
    }

    public static void resetLogId() {
        MDCLogUtil.cleanLogId();
        MDCLogUtil.setLogId();
    }

    private static String setLogId() {
        String ip = "_0";
        String logId = "";
        try {
            List<String> networkIPList = NetworkUtil.getNetworkIPList();
            for (String str : networkIPList) {
                if ("127.0.0.1".equals(str)) continue;
                ip = "_" + str.substring(str.lastIndexOf(".") + 1);
            }
            logId = ShortUUID.uuid() + ip;
            MDC.put((String)"ruid", (String)logId);
        }
        catch (Exception e) {
            log.error("setLogId error", (Throwable)e);
        }
        return logId;
    }

    public static void cleanLogId() {
        try {
            MDC.remove((String)"ruid");
        }
        catch (Exception e) {
            log.error("error occur when cleaning logid ", (Throwable)e);
        }
    }
}

