/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.Iterator;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openoa.base.util.ExpressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class ProcessDefinitionUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionUtils.class);

    public static ActivityImpl getActivity(ProcessEngine processEngine, String processDefId, String activityId) {
        ProcessDefinitionEntity pde = ProcessDefinitionUtils.getProcessDefinition(processEngine, processDefId);
        return pde.findActivity(activityId);
    }

    public static ProcessDefinitionEntity getProcessDefinition(ProcessEngine processEngine, String processDefId) {
        return (ProcessDefinitionEntity)((RepositoryServiceImpl)processEngine.getRepositoryService()).getDeployedProcessDefinition(processDefId);
    }

    public static void grantPermission(ActivityImpl activity, String assigneeExpression, String candidateGroupIdExpressions, String candidateUserIdExpressions) throws Exception {
        TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activity.getActivityBehavior()).getTaskDefinition();
        taskDefinition.setAssigneeExpression(assigneeExpression == null ? null : new FixedValue(assigneeExpression));
        FieldUtils.writeField((Object)taskDefinition, (String)"candidateUserIdExpressions", ExpressionUtils.stringToExpressionSet(candidateUserIdExpressions), (boolean)true);
        FieldUtils.writeField((Object)taskDefinition, (String)"candidateGroupIdExpressions", ExpressionUtils.stringToExpressionSet(candidateGroupIdExpressions), (boolean)true);
        log.info(String.format("granting previledges for [%s, %s, %s] on [%s, %s]", assigneeExpression, candidateGroupIdExpressions, candidateUserIdExpressions, activity.getProcessDefinition().getKey(), activity.getProperty("name")));
    }

    public static Integer currentTaskParallelism(String taskId) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        RuntimeService runtimeService = processEngine.getRuntimeService();
        Task task = (Task)((TaskQuery)taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return 0;
        }
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        if (execution == null) {
            return 0;
        }
        String parentExecutionId = execution.getParentId();
        if (parentExecutionId == null) {
            return 0;
        }
        List siblingExecutions = runtimeService.createExecutionQuery().parentId(parentExecutionId).list();
        if (CollectionUtils.isEmpty(siblingExecutions)) {
            return 0;
        }
        return siblingExecutions.size();
    }

    public static boolean isUserTaskParallel(String procInstId, String taskDefKey) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        RuntimeService runtimeService = processEngine.getRuntimeService();
        HistoryService historyService = processEngine.getHistoryService();
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(procInstId)).taskDefinitionKey(taskDefKey)).list();
        if (CollectionUtils.isEmpty(historicTaskInstances)) {
            return false;
        }
        String executionId = ((HistoricTaskInstance)historicTaskInstances.get(0)).getExecutionId();
        ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            return false;
        }
        return execution.isConcurrent();
    }

    public static boolean isUserTaskParallel(Task specifiedTask) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        RuntimeService runtimeService = processEngine.getRuntimeService();
        ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().executionId(specifiedTask.getExecutionId()).singleResult();
        if (execution == null) {
            return false;
        }
        return execution.isConcurrent();
    }

    public static ActivityImpl findClosestStartParallelGateway(String procInstId) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        RepositoryService repositoryService = processEngine.getRepositoryService();
        List tasks = ((TaskQuery)taskService.createTaskQuery().processInstanceId(procInstId)).list();
        if (CollectionUtils.isEmpty(tasks)) {
            return null;
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(((Task)tasks.get(0)).getProcessDefinitionId());
        ActivityImpl activity = processDefinition.findActivity(((Task)tasks.get(0)).getTaskDefinitionKey());
        return ProcessDefinitionUtils.findParallelGatewayRecursively(activity);
    }

    private static ActivityImpl findParallelGatewayRecursively(ActivityImpl activity) {
        if (activity == null) {
            return null;
        }
        List<PvmTransition> incomingTransitions = activity.getIncomingTransitions();
        for (PvmTransition transition : incomingTransitions) {
            ActivityImpl source = (ActivityImpl)transition.getSource();
            if ("parallelGateway".equals(source.getProperty("type"))) {
                return source;
            }
            ActivityImpl parallelGatewayRecursively = ProcessDefinitionUtils.findParallelGatewayRecursively(source);
            if (parallelGatewayRecursively == null) continue;
            return parallelGatewayRecursively;
        }
        return null;
    }

    public static ActivityImpl findJoinParallelGatewayRecursively(ActivityImpl startGateway) {
        if (startGateway == null) {
            return null;
        }
        List<PvmTransition> outgoingTransitions = startGateway.getOutgoingTransitions();
        for (PvmTransition transition : outgoingTransitions) {
            ActivityImpl target = (ActivityImpl)transition.getDestination();
            if ("parallelGateway".equals(target.getProperty("type"))) {
                return target;
            }
            ActivityImpl gateway = ProcessDefinitionUtils.findJoinParallelGatewayRecursively(target);
            if (gateway == null) continue;
            return gateway;
        }
        return null;
    }

    public static void findUserTasksBetweenGatewaysRecursively(ActivityImpl startGateway, ActivityImpl joinGateway, List<ActivityImpl> userTasks) {
        PvmTransition transition;
        ActivityImpl nextActivity;
        if (startGateway == null || joinGateway == null) {
            return;
        }
        List<PvmTransition> outgoingTransitions = startGateway.getOutgoingTransitions();
        Iterator<PvmTransition> iterator = outgoingTransitions.iterator();
        while (iterator.hasNext() && !(nextActivity = (ActivityImpl)(transition = iterator.next()).getDestination()).equals(joinGateway)) {
            if ("userTask".equals(nextActivity.getProperty("type"))) {
                userTasks.add(nextActivity);
            }
            ProcessDefinitionUtils.findUserTasksBetweenGatewaysRecursively(nextActivity, joinGateway, userTasks);
        }
    }
}

