/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.concurrent.TimeUnit;

public interface Retryer
extends Cloneable {
    public void continueOrPropagate(RuntimeException var1);

    public static class Default
    implements Retryer {
        private long period;
        private long maxPeriod;
        private int attempt;
        private int maxAttempts;

        public Default() {
            this(TimeUnit.SECONDS.toMillis(1L), 3);
        }

        public Default(long period, int maxAttempts) {
            this.period = period;
            this.maxPeriod = TimeUnit.SECONDS.toMillis(10L);
            this.maxAttempts = maxAttempts;
            this.attempt = 1;
        }

        public Default(long period, long maxPeriod, int maxAttempts) {
            this.period = period;
            this.maxPeriod = maxPeriod;
            this.maxAttempts = maxAttempts;
            this.attempt = 1;
        }

        @Override
        public void continueOrPropagate(RuntimeException e) {
            if (this.attempt++ >= this.maxAttempts) {
                throw e;
            }
            try {
                Thread.sleep(this.nextMaxInterval());
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        long nextMaxInterval() {
            long interval = (long)((double)this.period * Math.pow(1.5, (double)this.attempt - 1.0));
            return interval > this.maxPeriod ? this.maxPeriod : interval;
        }
    }
}

