/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.base.Strings;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ObjectUtils;

public class StrUtils {
    public static final Integer BPMN_CODE_LEN = 5;
    public static final String BPMNCONF_PATTERN = ".*-([0-9]{" + BPMN_CODE_LEN + "})";
    @TableField(exist=false)
    public static final String BPMNCONF_FORMATMARK = "%0" + BPMN_CODE_LEN + "d";

    public static String getFirstLetters(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        String finalStr = StrUtils.getFirstPinYin(s);
        return finalStr;
    }

    public static String joinBpmnCode(String bpmncodePart, String bpmnCode) {
        int defaultNum = 1;
        String maxNumStr = "";
        if (Pattern.matches(BPMNCONF_PATTERN, bpmnCode)) {
            String[] strings = bpmnCode.split("-");
            maxNumStr = strings[strings.length - 1];
        }
        if (!Strings.isNullOrEmpty((String)maxNumStr)) {
            defaultNum = Integer.parseInt(maxNumStr) + 1;
        }
        String stringWithRawFormat = bpmncodePart + "-" + BPMNCONF_FORMATMARK;
        String reJoinedBpmnCode = String.format(stringWithRawFormat, defaultNum);
        return reJoinedBpmnCode;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (!ObjectUtils.isEmpty((Object)srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static String getBeanName(Class<?> cls) {
        String simpleName = cls.getSimpleName();
        String beanName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        return beanName;
    }

    private static String getFirstPinYin(String hanyu) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder firstPinyin = new StringBuilder();
        char[] hanyuArr = hanyu.trim().toCharArray();
        try {
            int len = hanyuArr.length;
            for (int i = 0; i < len; ++i) {
                if (Character.toString(hanyuArr[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] pys = PinyinHelper.toHanyuPinyinStringArray((char)hanyuArr[i], (HanyuPinyinOutputFormat)format);
                    firstPinyin.append(pys[0].charAt(0));
                    continue;
                }
                firstPinyin.append(hanyuArr[i]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            badHanyuPinyinOutputFormatCombination.printStackTrace();
        }
        return firstPinyin.toString();
    }
}

