/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.interf.AdaptorService;
import org.openoa.base.vo.BpmnConfCommonButtonPropertyVo;
import org.openoa.base.vo.BpmnConfCommonButtonsVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.common.constant.enus.ElementPropertyEnum;
import org.openoa.common.util.BpmnElementUtils;
import org.springframework.util.CollectionUtils;

public abstract class BpmnElementAdaptor
implements AdaptorService {
    protected abstract BpmnConfCommonElementVo getElementVo(BpmnNodePropertysVo var1, BpmnNodeParamsVo var2, Integer var3, String var4);

    public void doFormatNodesToElements(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnNodeVo nodeVo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        BpmnConfCommonElementVo elementVo = this.formatNodesToElements(bpmnConfCommonElementVos, nodeVo, nodeCode, sequenceFlowNum, numMap);
        elementVo.setNodeId(nodeVo.getId().toString());
        elementVo.setLabelList(nodeVo.getLabelList());
        this.doSignUp(bpmnConfCommonElementVos, elementVo, numMap);
    }

    private BpmnConfCommonElementVo formatNodesToElements(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnNodeVo nodeVo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        String elementId = ProcessNodeEnum.getDescByCode((Integer)(nodeCode + 1));
        nodeVo.setElementId(elementId);
        BpmnConfCommonElementVo elementVo = this.getElementVo(nodeVo.getProperty(), nodeVo.getParams(), nodeCode + 1, elementId);
        this.setElementButtons(nodeVo, elementVo);
        elementVo.setTemplateVos(nodeVo.getTemplateVos());
        elementVo.setApproveRemindVo(nodeVo.getApproveRemindVo());
        this.setSignUpProperty(nodeVo, elementVo);
        bpmnConfCommonElementVos.add(elementVo);
        boolean hasAlreadyFlowTo = false;
        if (!CollectionUtils.isEmpty((Collection)nodeVo.getFromNodes())) {
            hasAlreadyFlowTo = true;
            BpmnConfCommonElementVo parallelGateWayElement = BpmnElementUtils.getParallelGateWayElement(sequenceFlowNum + 1);
            bpmnConfCommonElementVos.add(parallelGateWayElement);
            String parallelGateWayElementElementId = parallelGateWayElement.getElementId();
            Integer n = sequenceFlowNum;
            sequenceFlowNum = sequenceFlowNum + 1;
            Integer n2 = sequenceFlowNum;
            List fromNodes = nodeVo.getFromNodes();
            for (BpmnNodeVo fromNode : fromNodes) {
                String fromNodeElementId = fromNode.getElementId();
                bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(sequenceFlowNum + 1, fromNodeElementId, parallelGateWayElementElementId));
                Integer n3 = sequenceFlowNum;
                Integer n4 = sequenceFlowNum = Integer.valueOf(sequenceFlowNum + 1);
            }
            bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(sequenceFlowNum + 1, parallelGateWayElementElementId, elementVo.getElementId()));
        }
        if (!hasAlreadyFlowTo) {
            for (BpmnConfCommonElementVo bpmnConfCommonElementVo : bpmnConfCommonElementVos) {
                if (!elementVo.getElementId().equals(bpmnConfCommonElementVo.getFlowTo())) continue;
                hasAlreadyFlowTo = true;
                break;
            }
        }
        if (!hasAlreadyFlowTo) {
            bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(sequenceFlowNum + 1, ProcessNodeEnum.getDescByCode((Integer)nodeCode), elementVo.getElementId()));
        }
        Object object = nodeCode;
        Integer n = nodeCode = Integer.valueOf(nodeCode + 1);
        object = sequenceFlowNum;
        n = sequenceFlowNum = Integer.valueOf(sequenceFlowNum + 1);
        numMap.put("nodeCode", nodeCode);
        numMap.put("sequenceFlowNum", sequenceFlowNum);
        return elementVo;
    }

    private void setSignUpProperty(BpmnNodeVo nodeVo, BpmnConfCommonElementVo elementVo) {
        elementVo.setIsSignUp(Optional.ofNullable(nodeVo.getIsSignUp()).orElse(0).intValue());
        elementVo.setAfterSignUpWay(Optional.ofNullable(nodeVo.getProperty()).orElse(new BpmnNodePropertysVo()).getAfterSignUpWay());
        elementVo.setSignUpType(Optional.ofNullable(nodeVo.getProperty()).orElse(new BpmnNodePropertysVo()).getSignUpType());
    }

    private void doSignUp(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnConfCommonElementVo fatherElementVo, HashMap<String, Integer> numMap) {
        if (Objects.equals(fatherElementVo.getIsSignUp(), 1)) {
            switch (fatherElementVo.getAfterSignUpWay()) {
                case 1: {
                    this.backApproval(bpmnConfCommonElementVos, fatherElementVo, numMap);
                    break;
                }
                default: {
                    this.unbackApproval(bpmnConfCommonElementVos, fatherElementVo, numMap);
                }
            }
        }
    }

    private void backApproval(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnConfCommonElementVo fatherElementVo, HashMap<String, Integer> numMap) {
        BpmnConfCommonElementVo signUpSubElementVo = this.setAndGetSignUpSubElement(bpmnConfCommonElementVos, fatherElementVo, numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
        this.addBackApproval(bpmnConfCommonElementVos, fatherElementVo, signUpSubElementVo, numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
    }

    private void addBackApproval(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnConfCommonElementVo fatherElementVo, BpmnConfCommonElementVo signUpSubElementVo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        Integer elementCode = nodeCode + 1;
        String elementId = ProcessNodeEnum.getDescByCode((Integer)elementCode);
        Integer elementSequenceFlowNum = sequenceFlowNum + 1;
        BpmnConfCommonElementVo backApprovalElementVo = BpmnElementUtils.getSignUpElement(elementId, signUpSubElementVo, ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_SERIAL.getCode());
        backApprovalElementVo.setElementName(fatherElementVo.getElementName());
        backApprovalElementVo.setIsSignUpSubElement(1);
        backApprovalElementVo.setIsBackSignUp(1);
        backApprovalElementVo.setSignUpElementId(fatherElementVo.getElementId());
        this.setSignUpElementButtions(backApprovalElementVo);
        bpmnConfCommonElementVos.add(backApprovalElementVo);
        bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(elementSequenceFlowNum, ProcessNodeEnum.getDescByCode((Integer)nodeCode), backApprovalElementVo.getElementId()));
        Integer n = nodeCode;
        Integer n2 = nodeCode = Integer.valueOf(nodeCode + 1);
        n = sequenceFlowNum;
        n2 = sequenceFlowNum = Integer.valueOf(sequenceFlowNum + 1);
        numMap.put("nodeCode", nodeCode);
        numMap.put("sequenceFlowNum", sequenceFlowNum);
    }

    private void unbackApproval(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnConfCommonElementVo fatherElementVo, HashMap<String, Integer> numMap) {
        this.setAndGetSignUpSubElement(bpmnConfCommonElementVos, fatherElementVo, numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
    }

    private BpmnConfCommonElementVo setAndGetSignUpSubElement(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, BpmnConfCommonElementVo fatherElementVo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        BpmnConfCommonElementVo signUpElementVo;
        Integer elementCode = nodeCode + 1;
        String elementId = ProcessNodeEnum.getDescByCode((Integer)elementCode);
        Integer elementSequenceFlowNum = sequenceFlowNum + 1;
        switch (fatherElementVo.getSignUpType()) {
            case 1: {
                signUpElementVo = BpmnElementUtils.getSignUpElement(elementId, fatherElementVo, ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_SERIAL.getCode());
                break;
            }
            case 2: {
                signUpElementVo = BpmnElementUtils.getSignUpElement(elementId, fatherElementVo, ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_PARALLEL.getCode());
                break;
            }
            case 3: {
                signUpElementVo = BpmnElementUtils.getSignUpElement(elementId, fatherElementVo, ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_PARALLEL_OR.getCode());
                break;
            }
            default: {
                signUpElementVo = BpmnElementUtils.getSignUpElement(elementId, fatherElementVo, ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_SERIAL.getCode());
            }
        }
        signUpElementVo.setIsSignUpSubElement(1);
        signUpElementVo.setSignUpElementId(fatherElementVo.getElementId());
        this.setSignUpElementButtions(signUpElementVo);
        bpmnConfCommonElementVos.add(signUpElementVo);
        BpmnConfCommonElementVo signUpSequenceFlow = BpmnElementUtils.getSequenceFlow(elementSequenceFlowNum, ProcessNodeEnum.getDescByCode((Integer)nodeCode), signUpElementVo.getElementId());
        signUpSequenceFlow.setIsSignUpSequenceFlow(1);
        bpmnConfCommonElementVos.add(signUpSequenceFlow);
        Integer n = nodeCode;
        Integer n2 = nodeCode = Integer.valueOf(nodeCode + 1);
        n = sequenceFlowNum;
        n2 = sequenceFlowNum = Integer.valueOf(sequenceFlowNum + 1);
        numMap.put("nodeCode", nodeCode);
        numMap.put("sequenceFlowNum", sequenceFlowNum);
        return signUpElementVo;
    }

    protected void setElementButtons(BpmnNodeVo nodeVo, BpmnConfCommonElementVo elementVo) {
        elementVo.setButtons(BpmnConfCommonButtonsVo.builder().startPage(nodeVo.getButtons().getStartPage().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).approvalPage(nodeVo.getButtons().getApprovalPage().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).build());
    }

    private void setSignUpElementButtions(BpmnConfCommonElementVo elementVo) {
        elementVo.setButtons(BpmnConfCommonButtonsVo.builder().approvalPage((List)Lists.newArrayList((Object[])new BpmnConfCommonButtonPropertyVo[]{BpmnConfCommonButtonPropertyVo.builder().buttonType(ButtonTypeEnum.BUTTON_TYPE_AGREE.getCode()).buttonName(ButtonTypeEnum.BUTTON_TYPE_AGREE.getDesc()).build(), BpmnConfCommonButtonPropertyVo.builder().buttonType(ButtonTypeEnum.BUTTON_TYPE_DISAGREE.getCode()).buttonName(ButtonTypeEnum.BUTTON_TYPE_DISAGREE.getDesc()).build()})).build());
    }
}

