/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.ElementTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.exception.JiMuBizException;
import org.openoa.base.util.BpmnUtils;
import org.openoa.base.util.FilterUtil;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnConfCommonButtonPropertyVo;
import org.openoa.base.vo.BpmnConfCommonButtonsVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.bpmnelementadp.BpmnElementAdaptor;
import org.openoa.common.util.BpmnElementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnNodeFormatImpl {
    private static final Logger log = LoggerFactory.getLogger(BpmnNodeFormatImpl.class);

    public List<BpmnConfCommonElementVo> getBpmnConfCommonElementVoList(BpmnConfCommonVo bpmnConfCommonVo, List<BpmnNodeVo> nodes, BpmnStartConditionsVo bpmnStartConditions) {
        if (ObjectUtils.isEmpty(nodes)) {
            return Collections.EMPTY_LIST;
        }
        Integer sequenceFlowNum = 1;
        String startElementId = ProcessNodeEnum.START_TASK_KEY.getDesc();
        ArrayList bpmnConfCommonElementVos = Lists.newArrayList();
        String startEventElementId = StringUtils.join((Object[])new String[]{bpmnConfCommonVo.getProcessNum(), "_", ElementTypeEnum.ELEMENT_TYPE_START_EVENT.getDesc()});
        BpmnConfCommonElementVo startEventElement = BpmnElementUtils.getStartEventElement(startEventElementId);
        bpmnConfCommonElementVos.add(startEventElement);
        ArrayList rebuildNodesList = Lists.newArrayList();
        BpmnNodeVo startNode = this.getStartUserNode(nodes);
        rebuildNodesList.add(startNode);
        this.treatNodesRecursively(rebuildNodesList, nodes, startNode);
        BpmnNodeVo startUserNode = this.getStartUserNode(rebuildNodesList);
        String startUserId = Optional.ofNullable(bpmnStartConditions.getStartUserId()).map(Objects::toString).orElse("");
        HashMap<String, String> singleAssigneeMap = new HashMap<String, String>();
        singleAssigneeMap.put(startUserId, bpmnStartConditions.getStartUserName());
        BpmnConfCommonElementVo startNodeElement = BpmnElementUtils.getSingleElement(startElementId, "\u53d1\u8d77\u4eba", "startUser", startUserId, singleAssigneeMap);
        this.setStartNodeElementButtons(startUserNode, startNodeElement);
        startNodeElement.setTemplateVos(startUserNode.getTemplateVos());
        startNodeElement.setApproveRemindVo(startUserNode.getApproveRemindVo());
        bpmnConfCommonElementVos.add(startNodeElement);
        bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(sequenceFlowNum, startEventElement.getElementId(), startNodeElement.getElementId()));
        Integer nodeCode = ProcessNodeEnum.getCodeByDesc((String)startElementId);
        HashMap numMap = Maps.newHashMap();
        numMap.put("nodeCode", nodeCode);
        numMap.put("sequenceFlowNum", sequenceFlowNum);
        String startUserNodeTo = this.getNodeTo(startUserNode);
        if (!ObjectUtils.isEmpty((Object)startUserNodeTo)) {
            this.formatNodes(bpmnConfCommonElementVos, rebuildNodesList, startUserNodeTo, nodeCode, sequenceFlowNum, numMap);
        }
        String lastNodeId = ProcessNodeEnum.getDescByCode((Integer)((Integer)numMap.get("nodeCode")));
        Integer lastSequenceFlowNum = (Integer)numMap.get("sequenceFlowNum") + 1;
        String endEventElementId = StringUtils.join((Object[])new String[]{bpmnConfCommonVo.getProcessNum(), "_", ElementTypeEnum.ELEMENT_TYPE_END_EVENT.getDesc()});
        BpmnConfCommonElementVo endEventElement = BpmnElementUtils.getEndEventElement(endEventElementId);
        bpmnConfCommonElementVos.add(endEventElement);
        BpmnConfCommonElementVo lastSequenceFlow = BpmnElementUtils.getSequenceFlow(lastSequenceFlowNum, lastNodeId, endEventElement.getElementId());
        lastSequenceFlow.setIsLastSequenceFlow(1);
        bpmnConfCommonElementVos.add(lastSequenceFlow);
        return bpmnConfCommonElementVos;
    }

    private void setStartNodeElementButtons(BpmnNodeVo startUserNode, BpmnConfCommonElementVo startNodeElement) {
        startNodeElement.setButtons(BpmnConfCommonButtonsVo.builder().startPage(startUserNode.getButtons().getStartPage().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).approvalPage(startUserNode.getButtons().getApprovalPage().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).build());
    }

    private BpmnNodeVo getStartUserNode(List<BpmnNodeVo> nodes) {
        List startNode = nodes.stream().filter(o -> o.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(startNode)) {
            throw new JiMuBizException("\u672a\u627e\u5230\u5f00\u59cb\u8282\u70b9\u6d41\u7a0b\u53d1\u8d77\u5931\u8d25");
        }
        return (BpmnNodeVo)startNode.get(0);
    }

    private void rebuildNodes(List<BpmnNodeVo> rebuildNodesList, List<BpmnNodeVo> nodes, BpmnNodeVo nodeVo) {
        BpmnNodeParamsVo nodeParamsVo = nodeVo.getParams();
        if (nodeParamsVo.getIsNodeDeduplication() == 1) {
            String nextNodeTo = this.getNodeTo(nodeVo);
            List nodeVos = rebuildNodesList.stream().filter(a -> a.getParams().getNodeTo().equals(nodeVo.getNodeId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(nodeVos)) {
                BpmnNodeVo vo = (BpmnNodeVo)nodeVos.get(0);
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(vo.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)vo, nodes);
                    if (aggregationNode == null) {
                        throw new JiMuBizException("there is a parallel gateway node,but can not get its aggregation node");
                    }
                    if (aggregationNode.getNodeId().equals(nextNodeTo)) {
                        nodeVo.getParams().setIsNodeDeduplication(0);
                        nodeVo.setDeduplicationExclude(true);
                        rebuildNodesList.add(nodeVo);
                        return;
                    }
                }
                vo.getParams().setNodeTo(nextNodeTo);
                List nodeTo = vo.getNodeTo();
                ArrayList<String> newNodeTos = new ArrayList<String>();
                for (String s : nodeTo) {
                    if (s.equals(nodeVo.getNodeId())) {
                        newNodeTos.add(nextNodeTo);
                        continue;
                    }
                    newNodeTos.add(s);
                }
                vo.setNodeTo(newNodeTos);
            }
        } else {
            rebuildNodesList.add(nodeVo);
        }
    }

    private void treatNodesRecursively(List<BpmnNodeVo> rebuildNodesList, List<BpmnNodeVo> nodes, BpmnNodeVo nodeVo) {
        Map<String, BpmnNodeVo> mapNodes = nodes.stream().collect(Collectors.toMap(BpmnNodeVo::getNodeId, a -> a, (k1, k2) -> k1));
        String nextId = null;
        do {
            String nodeTo;
            if (Strings.isNullOrEmpty((String)(nodeTo = this.getNodeTo(nodeVo)))) {
                return;
            }
            BpmnNodeVo nextNodeVo = this.getNextNodeVo(nodes, nodeTo);
            BpmnNodeParamsVo nextParams = nextNodeVo.getParams();
            if (nextParams == null || StringUtils.isEmpty((CharSequence)nextParams.getNodeTo()) && NodeTypeEnum.NODE_TYPE_COPY.getCode().equals(nextNodeVo.getNodeType())) {
                return;
            }
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nextNodeVo.getNodeType())) {
                BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nextNodeVo, mapNodes.values());
                this.treatParallelGateWayRecursively(nextNodeVo, aggregationNode, mapNodes, nodes, rebuildNodesList);
                nodeVo = aggregationNode;
                continue;
            }
            this.rebuildNodes(rebuildNodesList, nodes, nextNodeVo);
            nodeVo = nextNodeVo;
        } while (!StringUtils.isEmpty((CharSequence)(nextId = nodeVo.getParams().getNodeTo())));
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> mapNodes, List<BpmnNodeVo> nodes, List<BpmnNodeVo> rebuildNodesList) {
        if (itsAggregationNode == null) {
            throw new JiMuBizException("there is a parallel gateway node,but can not get its aggregation node!");
        }
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        this.rebuildNodes(rebuildNodesList, nodes, outerMostParallelGatewayNode);
        this.rebuildNodes(rebuildNodesList, nodes, itsAggregationNode);
        for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo;
            BpmnNodeVo nodeVo = currentNodeVo = mapNodes.get(nodeTo);
            while (nodeVo != null && !nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, mapNodes.values());
                    this.treatParallelGateWayRecursively(nodeVo, aggregationNode, mapNodes, nodes, rebuildNodesList);
                } else {
                    this.rebuildNodes(rebuildNodesList, nodes, nodeVo);
                }
                nodeVo = mapNodes.get(nodeVo.getParams().getNodeTo());
            }
        }
    }

    private Map<String, Integer> formatNodes(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, List<BpmnNodeVo> rebuildNodesList, String nodeTo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        rebuildNodesList = rebuildNodesList.stream().filter(FilterUtil.distinctByKeys((Function[])new Function[]{BpmnNodeVo::getNodeId})).collect(Collectors.toList());
        Map<String, BpmnNodeVo> mapNodes = rebuildNodesList.stream().collect(Collectors.toMap(BpmnNodeVo::getNodeId, a -> a, (k1, k2) -> k1));
        BpmnNodeVo aggregationNode = null;
        do {
            BpmnNodeVo nextNodeVo = this.getNextNodeVo(rebuildNodesList, nodeTo);
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nextNodeVo.getNodeType())) {
                aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nextNodeVo, mapNodes.values());
                Integer parallelGatWayNodeCode = numMap.get("nodeCode") + 1;
                Integer parallelGateWaySequenceFlowNum = numMap.get("sequenceFlowNum") + 1;
                numMap.put("nodeCode", parallelGatWayNodeCode);
                numMap.put("sequenceFlowNum", parallelGateWaySequenceFlowNum);
                BpmnConfCommonElementVo parallelGateWayElement = BpmnElementUtils.getParallelGateWayElement(parallelGateWaySequenceFlowNum);
                bpmnConfCommonElementVos.add(parallelGateWayElement);
                bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(parallelGateWaySequenceFlowNum, ProcessNodeEnum.getDescByCode((Integer)(parallelGatWayNodeCode - 1)), parallelGateWayElement.getElementId()));
                this.treatParallelGateWayRecursively(nextNodeVo, aggregationNode, mapNodes, bpmnConfCommonElementVos, rebuildNodesList, nextNodeVo.getNodeId(), parallelGatWayNodeCode, parallelGateWaySequenceFlowNum, numMap, new BpmnNodeVo(), new HashSet<String>());
                nodeTo = aggregationNode.getNodeId();
                continue;
            }
            if (nextNodeVo.equals(aggregationNode)) {
                List<BpmnNodeVo> nodeFroms = this.getNodeFroms(rebuildNodesList, nextNodeVo);
                nextNodeVo.setFromNodes(nodeFroms);
            }
            this.formatNodesToElements(bpmnConfCommonElementVos, rebuildNodesList, nextNodeVo.getNodeId(), numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
            nodeTo = nextNodeVo.getParams().getNodeTo();
        } while (!StringUtils.isEmpty((CharSequence)nodeTo));
        return numMap;
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> mapNodes, List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, List<BpmnNodeVo> rebuildNodesList, String nextNodeTo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap, BpmnNodeVo lastAggNode, Set<String> alreadyProcessNodeIds) {
        if (itsAggregationNode == null) {
            throw new JiMuBizException("there is a parallel gateway node,but can not get its aggregation node!");
        }
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        String parallelGatewayNodeNodeId = outerMostParallelGatewayNode.getNodeId();
        Integer gateWaySF = numMap.get("sequenceFlowNum");
        for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo = mapNodes.get(nodeTo);
            bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(numMap.get("sequenceFlowNum") + 1, "gateWay" + gateWaySF, ProcessNodeEnum.getDescByCode((Integer)(numMap.get("nodeCode") + 1))));
            BpmnNodeVo nodeVo = currentNodeVo;
            while (nodeVo != null && !nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (!alreadyProcessNodeIds.contains(nodeVo.getNodeId())) {
                    if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                        BpmnNodeVo aggregationNode;
                        alreadyProcessNodeIds.add(nodeVo.getNodeId());
                        lastAggNode = aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, mapNodes.values());
                        Integer parallelGatWayNodeCode = numMap.get("nodeCode") + 1;
                        Integer parallelGateWaySequenceFlowNum = numMap.get("sequenceFlowNum") + 1;
                        numMap.put("nodeCode", parallelGatWayNodeCode);
                        numMap.put("sequenceFlowNum", parallelGateWaySequenceFlowNum);
                        BpmnConfCommonElementVo parallelGateWayElement = BpmnElementUtils.getParallelGateWayElement(parallelGateWaySequenceFlowNum);
                        bpmnConfCommonElementVos.add(parallelGateWayElement);
                        bpmnConfCommonElementVos.add(BpmnElementUtils.getSequenceFlow(parallelGateWaySequenceFlowNum, ProcessNodeEnum.getDescByCode((Integer)(parallelGatWayNodeCode - 1)), parallelGateWayElement.getElementId()));
                        this.treatParallelGateWayRecursively(nodeVo, aggregationNode, mapNodes, bpmnConfCommonElementVos, rebuildNodesList, nodeVo.getNodeId(), numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap, aggregationNode, alreadyProcessNodeIds);
                    } else {
                        alreadyProcessNodeIds.add(nodeVo.getNodeId());
                        if (nodeVo.equals((Object)itsAggregationNode)) {
                            List<BpmnNodeVo> nodeFroms = this.getNodeFroms(rebuildNodesList, nodeVo);
                            nodeVo.setFromNodes(nodeFroms);
                        }
                        this.formatNodesToElements(bpmnConfCommonElementVos, rebuildNodesList, nodeVo.getNodeId(), numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
                    }
                }
                nodeVo = mapNodes.get(nodeVo.getParams().getNodeTo());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)lastAggNode.getNodeId())) {
            if (alreadyProcessNodeIds.contains(lastAggNode.getNodeId())) {
                return;
            }
            alreadyProcessNodeIds.add(lastAggNode.getNodeId());
            List<BpmnNodeVo> nodeFroms = this.getNodeFroms(rebuildNodesList, lastAggNode);
            lastAggNode.setFromNodes(nodeFroms);
            this.formatNodesToElements(bpmnConfCommonElementVos, rebuildNodesList, lastAggNode.getNodeId(), numMap.get("nodeCode"), numMap.get("sequenceFlowNum"), numMap);
        }
    }

    private Map<String, Integer> formatNodesToElements(List<BpmnConfCommonElementVo> bpmnConfCommonElementVos, List<BpmnNodeVo> rebuildNodesList, String nodeTo, Integer nodeCode, Integer sequenceFlowNum, HashMap<String, Integer> numMap) {
        BpmnNodeVo nextNodeVo = this.getNextNodeVo(rebuildNodesList, nodeTo);
        NodePropertyEnum nodePropertyEnum = NodePropertyEnum.getNodePropertyEnumByCode((Integer)nextNodeVo.getNodeProperty());
        BpmnElementAdaptor bean = null;
        Collection beans = SpringBeanUtils.getBeans(BpmnElementAdaptor.class);
        for (BpmnElementAdaptor bpmnElementAdaptor : beans) {
            if (!bpmnElementAdaptor.isSupportBusinessObject((Enum)nodePropertyEnum)) continue;
            bean = bpmnElementAdaptor;
            break;
        }
        if (!ObjectUtils.isEmpty(bean)) {
            bean.doFormatNodesToElements(bpmnConfCommonElementVos, nextNodeVo, nodeCode, sequenceFlowNum, numMap);
        }
        String nextNodeTo = this.getNodeTo(nextNodeVo);
        return numMap;
    }

    private String getNodeTo(BpmnNodeVo nodeVo) {
        return Optional.ofNullable(nodeVo.getParams()).map(BpmnNodeParamsVo::getNodeTo).orElse(null);
    }

    private BpmnNodeVo getNextNodeVo(List<BpmnNodeVo> nodes, String nodeTo) {
        List nextNodeVo = nodes.stream().filter(o -> o.getNodeId().equals(nodeTo)).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(nextNodeVo)) {
            throw new JiMuBizException("\u672a\u627e\u5230\u4e0b\u4e00\u8282\u70b9\u6d41\u7a0b\u53d1\u8d77\u5931\u8d25");
        }
        return (BpmnNodeVo)nextNodeVo.get(0);
    }

    private List<BpmnNodeVo> getNodeFroms(List<BpmnNodeVo> nodes, BpmnNodeVo currentNode) {
        if (currentNode == null) {
            throw new JiMuBizException("can not set null to current node");
        }
        ArrayList<BpmnNodeVo> results = new ArrayList<BpmnNodeVo>();
        for (BpmnNodeVo node : nodes) {
            if (node.getParams().getNodeTo() == null || !node.getParams().getNodeTo().equals(currentNode.getNodeId())) continue;
            results.add(node);
        }
        return results;
    }
}

