/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.bpmnelementadp.BpmnOptionalDuplicatesAdaptor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnOptionalDuplicatesImpl
implements BpmnOptionalDuplicatesAdaptor {
    @Override
    public BpmnConfVo optionalDuplicates(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditions) {
        ArrayList<String> approverList = new ArrayList<String>();
        String startNodeId = null;
        HashMap<String, BpmnNodeVo> mapNodes = new HashMap<String, BpmnNodeVo>();
        for (BpmnNodeVo vo : bpmnConfVo.getNodes()) {
            mapNodes.put(vo.getNodeId(), vo);
            if (ObjectUtils.isEmpty((Object)vo.getNodeType()) || !vo.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())) continue;
            startNodeId = vo.getNodeId();
        }
        String initiator = ((BpmnNodeVo)mapNodes.get(startNodeId)).getParams().getAssignee().getAssignee();
        approverList.add(initiator);
        BpmnNodeVo bpmnNodeVo = (BpmnNodeVo)mapNodes.get(startNodeId);
        String optionalNode = "";
        while (ObjectUtils.isEmpty((Object)bpmnNodeVo.getParams().getNodeTo())) {
            if ((bpmnNodeVo = (BpmnNodeVo)mapNodes.get(bpmnNodeVo.getParams().getNodeTo())).getNodeProperty().equals(7) && bpmnNodeVo.getIsDeduplication().equals(1)) {
                optionalNode = bpmnNodeVo.getNodeId();
                continue;
            }
            if (bpmnNodeVo.getParams().getParamType().equals(1)) {
                approverList.add(bpmnNodeVo.getParams().getAssignee().getAssignee());
                continue;
            }
            if (!bpmnNodeVo.getParams().getParamType().equals(2)) continue;
            approverList.addAll(bpmnNodeVo.getParams().getAssigneeList().stream().map(BpmnNodeParamsAssigneeVo::getAssignee).collect(Collectors.toList()));
        }
        if (!ObjectUtils.isEmpty((Object)optionalNode) && !ObjectUtils.isEmpty(mapNodes.get(optionalNode))) {
            bpmnNodeVo = (BpmnNodeVo)mapNodes.get(optionalNode);
            List assigneeList = bpmnNodeVo.getParams().getAssigneeList();
            int isNodeDeduplication = 1;
            for (BpmnNodeParamsAssigneeVo assignee : assigneeList) {
                if (approverList.contains(assignee.getAssignee())) {
                    assignee.setIsDeduplication(Integer.valueOf(1));
                    continue;
                }
                isNodeDeduplication = 0;
            }
            bpmnNodeVo.getParams().setIsNodeDeduplication(isNodeDeduplication);
        }
        return bpmnConfVo;
    }
}

