/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.formatter;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.exception.JiMuBizException;
import org.openoa.base.util.AfNodeUtils;
import org.openoa.base.util.BpmnUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.NodeLabelConstants;
import org.openoa.common.formatter.BpmnRemoveFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBpmnRemoveFormat
implements BpmnRemoveFormat {
    private static final Logger log = LoggerFactory.getLogger(AbstractBpmnRemoveFormat.class);

    @Override
    public void removeBpmnConf(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditions) {
        BpmnNodeVo vo2;
        String startNodeId = null;
        HashMap<String, BpmnNodeVo> mapNodes = new HashMap<String, BpmnNodeVo>();
        for (BpmnNodeVo vo2 : bpmnConfVo.getNodes()) {
            mapNodes.put(vo2.getNodeId(), vo2);
            if (ObjectUtils.isEmpty((Object)vo2.getNodeType()) || !vo2.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())) continue;
            startNodeId = vo2.getNodeId();
        }
        BpmnNodeVo preVo = (BpmnNodeVo)mapNodes.get(startNodeId);
        vo2 = (BpmnNodeVo)mapNodes.get(startNodeId);
        while (!ObjectUtils.isEmpty((Object)vo2.getParams().getNodeTo()) || NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(vo2.getNodeType())) {
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(vo2.getNodeType())) {
                BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)vo2, mapNodes.values());
                this.treatParallelGateWayRecursively(vo2, aggregationNode, mapNodes, bpmnStartConditions);
                vo2 = aggregationNode;
            } else {
                vo2 = (BpmnNodeVo)mapNodes.get(vo2.getParams().getNodeTo());
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(vo2.getNodeType())) continue;
                List<Supplier<Boolean>> suppliers = this.trueSuppliers(vo2, bpmnStartConditions);
                for (Supplier<Boolean> supplier : suppliers) {
                    if (!supplier.get().booleanValue()) continue;
                    String nodeTo = vo2.getParams().getNodeTo();
                    preVo.getParams().setNodeTo(nodeTo);
                    if (CollectionUtils.isEmpty((Collection)vo2.getEmpToForwardList())) continue;
                    BpmnNodeVo bpmnNodeVo = AfNodeUtils.getNextNodeOfTypeRecursively((String)nodeTo, (List)Lists.newArrayList((Object[])new Integer[]{NodeTypeEnum.NODE_TYPE_START.getCode(), NodeTypeEnum.NODE_TYPE_APPROVER.getCode()}), mapNodes, (boolean)false);
                    if (bpmnNodeVo != null) {
                        bpmnNodeVo.setEmpToForwardList(vo2.getEmpToForwardList());
                        bpmnNodeVo.updateLabelListPossible(NodeLabelConstants.copyNode);
                        continue;
                    }
                    if (NodeTypeEnum.NODE_TYPE_APPROVER.getCode().equals(preVo.getNodeType()) && preVo.getParams().getIsNodeDeduplication() == 0) {
                        preVo.setEmpToForwardList(vo2.getEmpToForwardList());
                        preVo.setLastNodeForward(true);
                    } else {
                        BpmnNodeVo nearestPrevUserTaskNode = AfNodeUtils.getNeareastPrevNodeOfTypeRecursively((String)preVo.getNodeId(), (List)Lists.newArrayList((Object[])new Integer[]{NodeTypeEnum.NODE_TYPE_START.getCode(), NodeTypeEnum.NODE_TYPE_APPROVER.getCode()}), mapNodes, (boolean)false);
                        if (nearestPrevUserTaskNode != null) {
                            nearestPrevUserTaskNode.setEmpToForwardList(vo2.getEmpToForwardList());
                            nearestPrevUserTaskNode.setLastNodeForward(true);
                        } else {
                            log.debug("nodeId:{} can not find nearest node from,please check whether it is the last node,this does not mean there is an error,but error prone", (Object)preVo.getNodeId());
                        }
                    }
                    log.debug("nodeId:{} can not find nodeTo,please check whether it is the last node,this does not mean there is an error,but error prone", (Object)nodeTo);
                }
            }
            preVo = vo2;
        }
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> mapNodes, BpmnStartConditionsVo bpmnStartConditions) {
        if (itsAggregationNode == null) {
            throw new JiMuBizException("there is a parallel gateway node,but can not get its aggregation node!");
        }
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo = mapNodes.get(nodeTo);
            BpmnNodeVo prevNode = mapNodes.get(currentNodeVo.getNodeId());
            BpmnNodeVo nodeVo = currentNodeVo;
            while (!nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, mapNodes.values());
                    this.treatParallelGateWayRecursively(nodeVo, aggregationNode, mapNodes, bpmnStartConditions);
                }
                if (!NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                    List<Supplier<Boolean>> suppliers = this.trueSuppliers(nodeVo, bpmnStartConditions);
                    for (Supplier<Boolean> supplier : suppliers) {
                        if (!supplier.get().booleanValue()) continue;
                        prevNode.getParams().setNodeTo(nodeVo.getParams().getNodeTo());
                        if (CollectionUtils.isEmpty((Collection)nodeVo.getEmpToForwardList())) continue;
                        BpmnNodeVo bpmnNodeVo = AfNodeUtils.getNextNodeOfTypeRecursively((String)nodeVo.getParams().getNodeTo(), (List)Lists.newArrayList((Object[])new Integer[]{NodeTypeEnum.NODE_TYPE_START.getCode(), NodeTypeEnum.NODE_TYPE_APPROVER.getCode()}), mapNodes, (boolean)false);
                        if (bpmnNodeVo != null) {
                            bpmnNodeVo.setEmpToForwardList(nodeVo.getEmpToForwardList());
                            bpmnNodeVo.updateLabelListPossible(NodeLabelConstants.copyNode);
                            continue;
                        }
                        if (NodeTypeEnum.NODE_TYPE_APPROVER.getCode().equals(prevNode.getNodeType()) && prevNode.getParams().getIsNodeDeduplication() == 0) {
                            prevNode.setEmpToForwardList(nodeVo.getEmpToForwardList());
                            prevNode.setLastNodeForward(true);
                        } else {
                            BpmnNodeVo nearestPrevUserTaskNode = AfNodeUtils.getNeareastPrevNodeOfTypeRecursively((String)prevNode.getNodeId(), (List)Lists.newArrayList((Object[])new Integer[]{NodeTypeEnum.NODE_TYPE_START.getCode(), NodeTypeEnum.NODE_TYPE_APPROVER.getCode()}), mapNodes, (boolean)false);
                            if (nearestPrevUserTaskNode != null) {
                                nearestPrevUserTaskNode.setEmpToForwardList(nodeVo.getEmpToForwardList());
                                nearestPrevUserTaskNode.setLastNodeForward(true);
                            } else {
                                log.debug("nodeId:{} can not find nearest node from,please check whether it is the last node,this does not mean there is an error,but error prone", (Object)prevNode.getNodeId());
                            }
                        }
                        log.debug("nodeId:{} can not find nodeTo,please check whether it is the last node,this does not mean there is an error,but error prone", (Object)nodeTo);
                    }
                    prevNode = nodeVo;
                }
                nodeVo = mapNodes.get(nodeVo.getParams().getNodeTo());
            }
        }
    }
}

