/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.util;

import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.dto.NodeExtraInfoDTO;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class BpmnBuildUtils {
    private static final String EVENT_TAKE = "take";
    private static final String EVENT_CREATE = "create";

    public static StartEvent createStartEvent(String startEventId, String startEventName) {
        StartEvent startEvent = new StartEvent();
        startEvent.setId(startEventId);
        startEvent.setName(startEventName);
        return startEvent;
    }

    public static UserTask createUserTask(String id, String name, String assigneeParamName) {
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(name);
        userTask.setAssignee(BpmnBuildUtils.formatParamName(assigneeParamName));
        BpmnBuildUtils.setTaskListener(userTask);
        return userTask;
    }

    public static UserTask createUserTask(BpmnConfCommonElementVo elementVo) {
        UserTask userTask = new UserTask();
        userTask.setId(elementVo.getElementId());
        userTask.setName(elementVo.getElementName());
        userTask.setAssignee(BpmnBuildUtils.formatParamName(elementVo.getAssigneeParamName()));
        BpmnBuildUtils.setTaskListener(userTask, elementVo);
        return userTask;
    }

    public static UserTask createSignUserTask(String id, String name, String collectionName, String elementVariableName) {
        return BpmnBuildUtils.createMultiplayerUserTask(id, name, collectionName, elementVariableName, false);
    }

    public static UserTask createSignUserTask(BpmnConfCommonElementVo elementVo) {
        return BpmnBuildUtils.createMultiplayerUserTask(elementVo, false);
    }

    public static UserTask createOrSignUserTask(String id, String name, String collectionName, String elementVariableName) {
        return BpmnBuildUtils.createMultiplayerUserTask(id, name, collectionName, elementVariableName, true);
    }

    public static UserTask createOrSignUserTask(BpmnConfCommonElementVo elementVo) {
        return BpmnBuildUtils.createMultiplayerUserTask(elementVo, true);
    }

    private static UserTask createMultiplayerUserTask(String id, String name, String collectionName, String elementVariableName, Boolean isOrSign) {
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(name);
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setSequential(false);
        multiInstanceLoopCharacteristics.setInputDataItem(BpmnBuildUtils.formatParamName(collectionName));
        multiInstanceLoopCharacteristics.setElementVariable(elementVariableName);
        if (isOrSign.booleanValue()) {
            multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances >= 1 }");
        }
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        userTask.setAssignee(BpmnBuildUtils.formatParamName(elementVariableName));
        BpmnBuildUtils.setTaskListener(userTask);
        return userTask;
    }

    private static UserTask createMultiplayerUserTask(BpmnConfCommonElementVo elementVo, Boolean isOrSign) {
        UserTask userTask = new UserTask();
        userTask.setId(elementVo.getElementId());
        userTask.setName(elementVo.getElementName());
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setSequential(false);
        multiInstanceLoopCharacteristics.setInputDataItem(BpmnBuildUtils.formatParamName(elementVo.getCollectionName()));
        String elementVariableName = StringUtils.join((Object[])new String[]{elementVo.getCollectionName().replace("List", ""), "s"});
        multiInstanceLoopCharacteristics.setElementVariable(elementVariableName);
        if (isOrSign.booleanValue()) {
            multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances >= 1 }");
        }
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        userTask.setAssignee(BpmnBuildUtils.formatParamName(elementVariableName));
        BpmnBuildUtils.setTaskListener(userTask, elementVo);
        return userTask;
    }

    public static UserTask createLoopUserTask(String id, String name, String assigneeParamName, String endLoopMark) {
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(name);
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setSequential(true);
        multiInstanceLoopCharacteristics.setLoopCardinality("10");
        multiInstanceLoopCharacteristics.setCompletionCondition(BpmnBuildUtils.formatParamName(endLoopMark));
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        userTask.setAssignee(BpmnBuildUtils.formatParamName(assigneeParamName));
        BpmnBuildUtils.setTaskListener(userTask);
        return userTask;
    }

    public static UserTask createLoopUserTask(String id, String name, String loopCardinality, String collectionName, String elementVariableName) {
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(name);
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setSequential(true);
        multiInstanceLoopCharacteristics.setLoopCardinality(BpmnBuildUtils.formatParamName(loopCardinality));
        multiInstanceLoopCharacteristics.setInputDataItem(BpmnBuildUtils.formatParamName(collectionName));
        multiInstanceLoopCharacteristics.setElementVariable(elementVariableName);
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        userTask.setAssignee(BpmnBuildUtils.formatParamName(elementVariableName));
        BpmnBuildUtils.setTaskListener(userTask);
        return userTask;
    }

    public static ExclusiveGateway createExclusiveGateway(String id) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(id);
        return exclusiveGateway;
    }

    public static ParallelGateway createParallelGateWay(String id) {
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(id);
        return parallelGateway;
    }

    public static SequenceFlow createSequenceFlow(BpmnConfCommonElementVo elementVo) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(elementVo.getElementId());
        flow.setSourceRef(elementVo.getFlowFrom());
        flow.setTargetRef(elementVo.getFlowTo());
        ArrayList activitiListeners = Lists.newArrayList();
        if (elementVo.getIsLastSequenceFlow() == 1) {
            activitiListeners.add(BpmnBuildUtils.getActivitiListener(EVENT_TAKE, "${bpmnExecutionListener}"));
        }
        if (!ObjectUtils.isEmpty((Object)activitiListeners)) {
            flow.setExecutionListeners((List)Lists.newArrayList((Iterable)activitiListeners));
        }
        return flow;
    }

    public static SequenceFlow createSequenceFlow(String flowId, String from, String to, String conditionExpression) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(flowId);
        flow.setSourceRef(from);
        flow.setConditionExpression(BpmnBuildUtils.formatParamName(conditionExpression));
        flow.setTargetRef(to);
        return flow;
    }

    public static EndEvent createEndEvent(String endEventId, String endEventName) {
        EndEvent endEvent = new EndEvent();
        endEvent.setId(endEventId);
        endEvent.setName(endEventName);
        return endEvent;
    }

    private static void setTaskListener(UserTask userTask) {
        userTask.setTaskListeners((List)Lists.newArrayList((Object[])new ActivitiListener[]{BpmnBuildUtils.getActivitiListener(EVENT_CREATE, "${bpmnTaskListener}")}));
    }

    public static void setTaskListener(UserTask userTask, BpmnConfCommonElementVo elementVo) {
        ActivitiListener activitiTaskListener = BpmnBuildUtils.getActivitiListener(EVENT_CREATE, "${bpmnTaskListener}");
        if (!CollectionUtils.isEmpty((Collection)elementVo.getLabelList())) {
            ActivitiListener flowExecutionListener = BpmnBuildUtils.getActivitiListener("start", "${bpmnFlowExecutionListener}");
            FieldExtension field = new FieldExtension();
            field.setFieldName("extraInfo");
            NodeExtraInfoDTO extraInfoDTO = new NodeExtraInfoDTO();
            extraInfoDTO.setNodeLabelVOS(elementVo.getLabelList());
            field.setStringValue(JSON.toJSONString((Object)extraInfoDTO));
            List<FieldExtension> fieldExtensions = Collections.singletonList(field);
            activitiTaskListener.setFieldExtensions(fieldExtensions);
            flowExecutionListener.setFieldExtensions(fieldExtensions);
            userTask.setExecutionListeners((List)Lists.newArrayList((Object[])new ActivitiListener[]{flowExecutionListener}));
        }
        userTask.setTaskListeners((List)Lists.newArrayList((Object[])new ActivitiListener[]{activitiTaskListener}));
    }

    private static ActivitiListener getActivitiListener(String event, String implementation) {
        ActivitiListener activitiListener = new ActivitiListener();
        activitiListener.setEvent(event);
        activitiListener.setImplementationType("delegateExpression");
        activitiListener.setImplementation(implementation);
        return activitiListener;
    }

    private static String formatParamName(String paramName) {
        return StringUtils.join((Object[])new String[]{"${", paramName, "}"});
    }
}

