/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.config;

import io.github.pigmesh.ai.deepseek.config.DeepSeekProperties;
import io.github.pigmesh.ai.deepseek.core.DeepSeekClient;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

@AutoConfiguration
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DeepSeekProperties.class})
public class DeepSeekAutoConfiguration {
    @Value(value="classpath:/prompts/system.pt")
    private Resource systemResource;

    @Bean
    @ConditionalOnMissingBean
    public DeepSeekClient deepSeekClient(DeepSeekProperties deepSeekProperties) {
        DeepSeekClient.Builder builder = (DeepSeekClient.Builder)((DeepSeekClient.Builder)((DeepSeekClient.Builder)((DeepSeekClient.Builder)((DeepSeekClient.Builder)DeepSeekClient.builder().baseUrl(deepSeekProperties.getBaseUrl())).model(deepSeekProperties.getModel())).openAiApiKey(deepSeekProperties.getApiKey())).logRequests(Boolean.valueOf(deepSeekProperties.isLogRequests()))).logResponses(Boolean.valueOf(deepSeekProperties.isLogResponses()));
        if (Objects.nonNull(deepSeekProperties.getProxy())) {
            builder.proxy(deepSeekProperties.getProxy());
        }
        if (Objects.nonNull(deepSeekProperties.getConnectTimeout())) {
            builder.connectTimeout(Duration.ofSeconds(deepSeekProperties.getConnectTimeout().intValue()));
        }
        if (Objects.nonNull(deepSeekProperties.getReadTimeout())) {
            builder.readTimeout(Duration.ofSeconds(deepSeekProperties.getReadTimeout().intValue()));
        }
        if (Objects.nonNull(deepSeekProperties.getCallTimeout())) {
            builder.callTimeout(Duration.ofSeconds(deepSeekProperties.getCallTimeout().intValue()));
        }
        builder.logLevel(deepSeekProperties.getLogLevel());
        if (deepSeekProperties.isDefaultSystemPrompt()) {
            String systemMessage = StreamUtils.copyToString((InputStream)this.systemResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            builder.systemMessage(systemMessage);
        }
        builder.searchApiKey(deepSeekProperties.getSearchApiKey());
        return builder.build();
    }
}

