/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import io.grpc.BinaryLog;
import io.grpc.CallOptions;
import io.grpc.services.BinaryLogProvider;
import io.grpc.services.BinaryLogProviderImpl;
import io.grpc.services.BinaryLogSink;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.nio.ByteBuffer;

final class CensusBinaryLogProvider
extends BinaryLogProviderImpl {
    public CensusBinaryLogProvider() throws IOException {
    }

    public CensusBinaryLogProvider(BinaryLogSink sink) throws IOException {
        super(sink);
    }

    CensusBinaryLogProvider(BinaryLogSink sink, String configStr) throws IOException {
        super(sink, configStr);
    }

    @Override
    protected BinaryLog.CallId getServerCallId() {
        Span currentSpan = Tracing.getTracer().getCurrentSpan();
        return new BinaryLog.CallId(0L, ByteBuffer.wrap(currentSpan.getContext().getSpanId().getBytes()).getLong());
    }

    @Override
    protected BinaryLog.CallId getClientCallId(CallOptions options) {
        return (BinaryLog.CallId)options.getOption(BinaryLogProvider.CLIENT_CALL_ID_CALLOPTION_KEY);
    }
}

