/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.WildcardElement;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
final class JavaWildcardElement
extends JavaClassElement
implements WildcardElement {
    private final List<JavaClassElement> upperBounds;
    private final List<JavaClassElement> lowerBounds;

    JavaWildcardElement(@NonNull List<JavaClassElement> upperBounds, @NonNull List<JavaClassElement> lowerBounds) {
        super(upperBounds.get((int)0).classElement, upperBounds.get(0).getAnnotationMetadata(), upperBounds.get((int)0).visitorContext, upperBounds.get((int)0).typeArguments, upperBounds.get(0).getGenericTypeInfo());
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    @NonNull
    public List<? extends ClassElement> getUpperBounds() {
        return this.upperBounds;
    }

    @NonNull
    public List<? extends ClassElement> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions != 0) {
            throw new UnsupportedOperationException("Can't create array of wildcard");
        }
        return this;
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List<JavaClassElement> upperBounds = this.upperBounds.stream().map(ele -> this.toJavaClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        List<JavaClassElement> lowerBounds = this.lowerBounds.stream().map(ele -> this.toJavaClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        return fold.apply((ClassElement)(upperBounds.contains(null) || lowerBounds.contains(null) ? null : new JavaWildcardElement(upperBounds, lowerBounds)));
    }

    private JavaClassElement toJavaClassElement(ClassElement element) {
        if (element == null || element instanceof JavaClassElement) {
            return (JavaClassElement)element;
        }
        if (element.isWildcard() || element.isGenericPlaceholder()) {
            throw new UnsupportedOperationException("Cannot convert wildcard / free type variable to JavaClassElement");
        }
        return (JavaClassElement)((ArrayableClassElement)this.visitorContext.getClassElement(element.getName()).orElseThrow(() -> new UnsupportedOperationException("Cannot convert ClassElement to JavaClassElement, class was not found on the visitor context"))).withArrayDimensions(element.getArrayDimensions()).withBoundGenericTypes(element.getBoundGenericTypes());
    }
}

