/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class AlterDatabaseParam {
    private final String databaseName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterDatabaseParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.properties.putAll(builder.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "AlterDatabaseParam(databaseName=" + this.getDatabaseName() + ", properties=" + this.getProperties() + ")";
    }

    public static final class Builder {
        private String databaseName;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withDatabaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked non-null but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public Builder withReplicaNumber(int replicaNumber) {
            return this.withProperty("database.replica.number", Integer.toString(replicaNumber));
        }

        public Builder WithResourceGroups(@NonNull List<String> resourceGroups) {
            if (resourceGroups == null) {
                throw new NullPointerException("resourceGroups is marked non-null but is null");
            }
            return this.withProperty("database.resource_groups", String.join((CharSequence)",", resourceGroups));
        }

        public Builder withProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.properties.put(key, value);
            return this;
        }

        public AlterDatabaseParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.databaseName, "Database name");
            return new AlterDatabaseParam(this);
        }
    }
}

