/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.stub;

import io.mockk.MockKException;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.MultiNotifier;
import io.mockk.impl.WeakRef;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.stub.MockKStub;
import io.mockk.impl.stub.Stub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0007J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0001H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0001J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/mockk/impl/stub/StubRepository;", "", "safeToString", "Lio/mockk/impl/log/SafeToString;", "(Lio/mockk/impl/log/SafeToString;)V", "allStubs", "", "Lio/mockk/impl/stub/Stub;", "getAllStubs", "()Ljava/util/List;", "recordCallMultiNotifier", "Lio/mockk/impl/MultiNotifier;", "getSafeToString", "()Lio/mockk/impl/log/SafeToString;", "stubs", "", "Lio/mockk/impl/WeakRef;", "add", "", "mock", "stub", "get", "notifyCallRecorded", "Lio/mockk/impl/stub/MockKStub;", "openRecordCallAwaitSession", "Lio/mockk/impl/MultiNotifier$Session;", "timeout", "", "remove", "stubFor", "mockk"})
public final class StubRepository {
    @NotNull
    private final SafeToString safeToString;
    @NotNull
    private final Map<Object, WeakRef> stubs;
    @NotNull
    private final MultiNotifier recordCallMultiNotifier;

    public StubRepository(@NotNull SafeToString safeToString2) {
        Intrinsics.checkNotNullParameter((Object)safeToString2, (String)"safeToString");
        this.safeToString = safeToString2;
        this.stubs = InternalPlatform.INSTANCE.weakMap();
        this.recordCallMultiNotifier = InternalPlatform.INSTANCE.multiNotifier();
    }

    @NotNull
    public final SafeToString getSafeToString() {
        return this.safeToString;
    }

    @NotNull
    public final Stub stubFor(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.get(mock2);
        if (stub == null) {
            throw new MockKException((String)this.safeToString.exec((Function0)new Function0<String>(mock2){
                final /* synthetic */ Object $mock;
                {
                    this.$mock = $mock;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "can't find stub " + this.$mock;
                }
            }), null, 2, null);
        }
        return stub;
    }

    public final void add(@NotNull Object mock2, @NotNull Stub stub) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        this.stubs.put(mock2, InternalPlatform.INSTANCE.weakRef(stub));
    }

    @Nullable
    public final Stub remove(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        WeakRef weakRef2 = this.stubs.remove(mock2);
        Object object = weakRef2 != null ? weakRef2.getValue() : null;
        return object instanceof Stub ? (Stub)object : null;
    }

    @Nullable
    public final Stub get(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        WeakRef weakRef2 = this.stubs.get(mock2);
        Object object = weakRef2 != null ? weakRef2.getValue() : null;
        return object instanceof Stub ? (Stub)object : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Stub> getAllStubs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.stubs.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Stub it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WeakRef it = (WeakRef)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getValue();
            if ((object instanceof Stub ? (Stub)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void notifyCallRecorded(@NotNull MockKStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        this.recordCallMultiNotifier.notify(stub);
    }

    @NotNull
    public final MultiNotifier.Session openRecordCallAwaitSession(@NotNull List<? extends Stub> stubs, long timeout) {
        Intrinsics.checkNotNullParameter(stubs, (String)"stubs");
        return this.recordCallMultiNotifier.openSession(stubs, timeout);
    }
}

