/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramPacket;
import io.netty.incubator.codec.quic.FlushStrategy;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.QuicPacketType;
import io.netty.incubator.codec.quic.QuicResetTokenGenerator;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.QuicheConfig;
import io.netty.incubator.codec.quic.QuicheQuicChannel;
import io.netty.incubator.codec.quic.QuicheQuicCodec;
import io.netty.incubator.codec.quic.QuicheQuicConnection;
import io.netty.incubator.codec.quic.QuicheQuicSslEngine;
import io.netty.incubator.codec.quic.SockaddrIn;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class QuicheQuicServerCodec
extends QuicheQuicCodec {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(QuicheQuicServerCodec.class);
    private final Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider;
    private final Executor sslTaskExecutor;
    private final QuicConnectionIdGenerator connectionIdAddressGenerator;
    private final QuicResetTokenGenerator resetTokenGenerator;
    private final QuicTokenHandler tokenHandler;
    private final ChannelHandler handler;
    private final Map.Entry<ChannelOption<?>, Object>[] optionsArray;
    private final Map.Entry<AttributeKey<?>, Object>[] attrsArray;
    private final ChannelHandler streamHandler;
    private final Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray;
    private final Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray;
    private ByteBuf mintTokenBuffer;
    private ByteBuf connIdBuffer;

    QuicheQuicServerCodec(QuicheConfig config, int localConnIdLength, QuicTokenHandler tokenHandler, QuicConnectionIdGenerator connectionIdAddressGenerator, QuicResetTokenGenerator resetTokenGenerator, FlushStrategy flushStrategy, Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider, Executor sslTaskExecutor, ChannelHandler handler, Map.Entry<ChannelOption<?>, Object>[] optionsArray, Map.Entry<AttributeKey<?>, Object>[] attrsArray, ChannelHandler streamHandler, Map.Entry<ChannelOption<?>, Object>[] streamOptionsArray, Map.Entry<AttributeKey<?>, Object>[] streamAttrsArray) {
        super(config, localConnIdLength, tokenHandler.maxTokenLength(), flushStrategy);
        this.tokenHandler = tokenHandler;
        this.connectionIdAddressGenerator = connectionIdAddressGenerator;
        this.resetTokenGenerator = resetTokenGenerator;
        this.sslEngineProvider = sslEngineProvider;
        this.sslTaskExecutor = sslTaskExecutor;
        this.handler = handler;
        this.optionsArray = optionsArray;
        this.attrsArray = attrsArray;
        this.streamHandler = streamHandler;
        this.streamOptionsArray = streamOptionsArray;
        this.streamAttrsArray = streamAttrsArray;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.connIdBuffer = Quiche.allocateNativeOrder(this.localConnIdLength);
        this.mintTokenBuffer = Quiche.allocateNativeOrder(this.tokenHandler.maxTokenLength());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        super.handlerRemoved(ctx);
        if (this.connIdBuffer != null) {
            this.connIdBuffer.release();
        }
        if (this.mintTokenBuffer != null) {
            this.mintTokenBuffer.release();
        }
    }

    @Override
    protected void channelRecv(QuicheQuicChannel channel, InetSocketAddress sender, InetSocketAddress recipient, ByteBuf buffer) {
        super.channelRecv(channel, sender, recipient, buffer);
        for (ByteBuffer retiredSourceConnectionId : channel.retiredSourceConnectionId()) {
            this.removeMapping(retiredSourceConnectionId);
        }
        for (ByteBuffer newSourceConnectionId : channel.newSourceConnectionIds(this.connectionIdAddressGenerator, this.resetTokenGenerator)) {
            this.addMapping(newSourceConnectionId, channel);
        }
    }

    @Override
    protected QuicheQuicChannel quicPacketRead(ChannelHandlerContext ctx, InetSocketAddress sender, InetSocketAddress recipient, QuicPacketType type, int version, ByteBuf scid, ByteBuf dcid, ByteBuf token) throws Exception {
        ByteBuffer dcidByteBuffer = dcid.internalNioBuffer(dcid.readerIndex(), dcid.readableBytes());
        QuicheQuicChannel channel = this.getChannel(dcidByteBuffer);
        if (channel == null && type == QuicPacketType.ZERO_RTT && this.connectionIdAddressGenerator.isIdempotent()) {
            channel = this.getChannel(this.connectionIdAddressGenerator.newId(dcidByteBuffer, this.localConnIdLength));
        }
        if (channel == null) {
            return this.handleServer(ctx, sender, recipient, type, version, scid, dcid, token);
        }
        return channel;
    }

    private QuicheQuicChannel handleServer(ChannelHandlerContext ctx, InetSocketAddress sender, InetSocketAddress recipient, QuicPacketType type, int version, ByteBuf scid, ByteBuf dcid, ByteBuf token) throws Exception {
        int ocidLen;
        long ocidAddr;
        int scidLen;
        long scidAddr;
        ByteBuffer key;
        int offset;
        if (!Quiche.quiche_version_is_supported(version)) {
            ByteBuf out = ctx.alloc().directBuffer(1350);
            int outWriterIndex = out.writerIndex();
            int res = Quiche.quiche_negotiate_version(Quiche.readerMemoryAddress(scid), scid.readableBytes(), Quiche.readerMemoryAddress(dcid), dcid.readableBytes(), Quiche.writerMemoryAddress(out), out.writableBytes());
            if (res < 0) {
                out.release();
                Quiche.throwIfError(res);
            } else {
                ctx.writeAndFlush((Object)new DatagramPacket(out.writerIndex(outWriterIndex + res), sender));
            }
            return null;
        }
        boolean noToken = false;
        if (!token.isReadable()) {
            this.mintTokenBuffer.clear();
            this.connIdBuffer.clear();
            if (this.tokenHandler.writeToken(this.mintTokenBuffer, dcid, sender)) {
                ByteBuffer connId = this.connectionIdAddressGenerator.newId(dcid.internalNioBuffer(dcid.readerIndex(), dcid.readableBytes()), this.localConnIdLength);
                this.connIdBuffer.writeBytes(connId);
                ByteBuf out = ctx.alloc().directBuffer(1350);
                int outWriterIndex = out.writerIndex();
                int written = Quiche.quiche_retry(Quiche.readerMemoryAddress(scid), scid.readableBytes(), Quiche.readerMemoryAddress(dcid), dcid.readableBytes(), Quiche.readerMemoryAddress(this.connIdBuffer), this.connIdBuffer.readableBytes(), Quiche.readerMemoryAddress(this.mintTokenBuffer), this.mintTokenBuffer.readableBytes(), version, Quiche.writerMemoryAddress(out), out.writableBytes());
                if (written < 0) {
                    out.release();
                    Quiche.throwIfError(written);
                } else {
                    ctx.writeAndFlush((Object)new DatagramPacket(out.writerIndex(outWriterIndex + written), sender));
                }
                return null;
            }
            offset = 0;
            noToken = true;
        } else {
            offset = this.tokenHandler.validateToken(token, sender);
            if (offset == -1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("invalid token: {}", (Object)token.toString(CharsetUtil.US_ASCII));
                }
                return null;
            }
        }
        if (noToken) {
            this.connIdBuffer.clear();
            key = this.connectionIdAddressGenerator.newId(dcid.internalNioBuffer(dcid.readerIndex(), dcid.readableBytes()), this.localConnIdLength);
            this.connIdBuffer.writeBytes(key.duplicate());
            scidAddr = Quiche.readerMemoryAddress(this.connIdBuffer);
            scidLen = this.localConnIdLength;
            ocidAddr = -1L;
            ocidLen = -1;
            QuicheQuicChannel existingChannel = this.getChannel(key);
            if (existingChannel != null) {
                return existingChannel;
            }
        } else {
            scidAddr = Quiche.readerMemoryAddress(dcid);
            scidLen = this.localConnIdLength;
            ocidAddr = Quiche.memoryAddress(token, offset, token.readableBytes());
            ocidLen = token.readableBytes() - offset;
            byte[] bytes = new byte[this.localConnIdLength];
            dcid.getBytes(dcid.readerIndex(), bytes);
            key = ByteBuffer.wrap(bytes);
        }
        QuicheQuicChannel channel = QuicheQuicChannel.forServer(ctx.channel(), key, recipient, sender, this.config.isDatagramSupported(), this.streamHandler, this.streamOptionsArray, this.streamAttrsArray, this::removeChannel, this.sslTaskExecutor);
        Quic.setupChannel(channel, this.optionsArray, this.attrsArray, this.handler, LOGGER);
        QuicSslEngine engine = this.sslEngineProvider.apply(channel);
        if (!(engine instanceof QuicheQuicSslEngine)) {
            channel.unsafe().closeForcibly();
            throw new IllegalArgumentException("QuicSslEngine is not of type " + QuicheQuicSslEngine.class.getSimpleName());
        }
        if (engine.getUseClientMode()) {
            channel.unsafe().closeForcibly();
            throw new IllegalArgumentException("QuicSslEngine is not created in server mode");
        }
        QuicheQuicSslEngine quicSslEngine = (QuicheQuicSslEngine)engine;
        QuicheQuicConnection connection = quicSslEngine.createConnection(ssl -> {
            ByteBuffer localAddrMemory = this.recipientSockaddrMemory.internalNioBuffer(0, this.recipientSockaddrMemory.capacity());
            int localLen = SockaddrIn.setAddress(localAddrMemory, recipient);
            ByteBuffer peerAddrMemory = this.senderSockaddrMemory.internalNioBuffer(0, this.senderSockaddrMemory.capacity());
            int peerLen = SockaddrIn.setAddress(peerAddrMemory, sender);
            return Quiche.quiche_conn_new_with_tls(scidAddr, scidLen, ocidAddr, ocidLen, Quiche.memoryAddressWithPosition(localAddrMemory), localLen, Quiche.memoryAddressWithPosition(peerAddrMemory), peerLen, this.config.nativeAddress(), ssl, true);
        });
        if (connection == null) {
            channel.unsafe().closeForcibly();
            LOGGER.debug("quiche_accept failed");
            return null;
        }
        channel.attachQuicheConnection(connection);
        this.addChannel(channel);
        ctx.channel().eventLoop().register((Channel)channel);
        return channel;
    }
}

