/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.MockTicker;
import io.netty.util.concurrent.Ticker;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private final FreezableTicker ticker = new FreezableTicker();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    public void execute(Runnable command) {
        this.tasks.add((Runnable)ObjectUtil.checkNotNull((Object)command, (String)"command"));
    }

    void runTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            task.run();
        }
    }

    boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    long runScheduledTasks() {
        long time = this.getCurrentTimeNanos();
        Runnable task;
        while ((task = this.pollScheduledTask(time)) != null) {
            task.run();
        }
        return this.nextScheduledTaskNano();
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    public Ticker ticker() {
        return this.ticker;
    }

    protected long getCurrentTimeNanos() {
        return this.ticker.nanoTime();
    }

    void advanceTimeBy(long nanos) {
        this.ticker.advance(nanos, TimeUnit.NANOSECONDS);
    }

    void freezeTime() {
        this.ticker.freezeTime();
    }

    void unfreezeTime() {
        this.ticker.unfreezeTime();
    }

    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isShuttingDown() {
        return false;
    }

    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminated() {
        return false;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, (EventExecutor)this));
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        promise.channel().unsafe().register(this, promise);
        return promise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        channel.unsafe().register(this, promise);
        return promise;
    }

    public boolean inEventLoop() {
        return true;
    }

    public boolean inEventLoop(Thread thread) {
        return true;
    }

    private static final class FreezableTicker
    implements MockTicker {
        private final Ticker unfrozen = Ticker.systemTicker();
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private long startTime;
        private long frozenTimestamp;
        private boolean timeFrozen;

        private FreezableTicker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void advance(long amount, TimeUnit unit) {
            this.lock.lock();
            try {
                long nanos = unit.toNanos(amount);
                if (this.timeFrozen) {
                    this.frozenTimestamp += nanos;
                } else {
                    this.startTime -= nanos;
                }
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public long nanoTime() {
            this.lock.lock();
            try {
                if (this.timeFrozen) {
                    long l = this.frozenTimestamp;
                    return l;
                }
                long l = this.unfrozen.nanoTime() - this.startTime;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sleep(long delay, TimeUnit unit) throws InterruptedException {
            long deadline = this.nanoTime() + unit.toNanos(delay);
            this.lock.lockInterruptibly();
            try {
                long timeout;
                while ((timeout = deadline - this.nanoTime()) >= 0L) {
                    if (this.timeFrozen) {
                        this.cond.await();
                        continue;
                    }
                    this.cond.awaitNanos(timeout);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void freezeTime() {
            this.lock.lock();
            try {
                if (!this.timeFrozen) {
                    this.frozenTimestamp = this.nanoTime();
                    this.timeFrozen = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void unfreezeTime() {
            this.lock.lock();
            try {
                if (this.timeFrozen) {
                    this.startTime = this.unfrozen.nanoTime() - this.frozenTimestamp;
                    this.timeFrozen = false;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

