/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.utils.DevHelper;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class ServerFeatureSupport
extends BasicSupport {
    private static final String LIBERTY_MAVEN_PLUGIN_GROUP_ID = "io.openliberty.tools";
    private static final String LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID = "liberty-maven-plugin";
    private ServerFeatureUtil servUtil;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;

    private void createNewServerFeatureUtil() {
        this.servUtil = new ServerFeatureMojoUtil();
    }

    protected ServerFeatureUtil getServerFeatureUtil(boolean suppressLogs, Map<String, File> libDirPropFiles) {
        if (this.servUtil == null) {
            this.createNewServerFeatureUtil();
            this.servUtil.setLibertyDirectoryPropertyFiles(libDirPropFiles);
        }
        if (suppressLogs) {
            this.servUtil.setSuppressLogs(true);
        } else {
            this.servUtil.setSuppressLogs(false);
        }
        return this.servUtil;
    }

    private static boolean isSubModule(MavenProject potentialTopModule, MavenProject potentialSubModule) {
        List multiModules = potentialTopModule.getModules();
        if (multiModules != null) {
            for (String module : multiModules) {
                File subModuleDir = new File(potentialTopModule.getBasedir(), module);
                try {
                    if (!subModuleDir.getCanonicalFile().equals(potentialSubModule.getBasedir().getCanonicalFile())) continue;
                    return true;
                }
                catch (IOException e) {
                    if (!subModuleDir.getAbsoluteFile().equals(potentialSubModule.getBasedir().getAbsoluteFile())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected List<MavenProject> getRelevantMultiModuleProjects(ProjectDependencyGraph graph, boolean skipJars) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Resolve relevant multi-module projects");
        List sortedReactorProjects = graph.getSortedProjects();
        LinkedHashSet<MavenProject> conflicts = new LinkedHashSet<MavenProject>();
        ArrayList<MavenProject> leaves = new ArrayList<MavenProject>();
        for (MavenProject reactorProject : sortedReactorProjects) {
            if (!graph.getDownstreamProjects(reactorProject, true).isEmpty()) continue;
            this.getLog().debug((CharSequence)("Found final downstream project: " + reactorProject.getArtifactId()));
            if (this.skipConfigured(reactorProject)) {
                this.getLog().debug((CharSequence)("Skip configured on project: " + reactorProject.getArtifactId() + " - Ignoring"));
                continue;
            }
            if (reactorProject.getPackaging().equals("jar") && skipJars) {
                this.getLog().debug((CharSequence)(reactorProject.getArtifactId() + " is a jar project - Ignoring"));
                continue;
            }
            leaves.add(reactorProject);
        }
        for (MavenProject leaf1 : leaves) {
            for (MavenProject leaf2 : leaves) {
                if (leaf1 == leaf2 || ServerFeatureSupport.isSubModule(leaf2, leaf1) || ServerFeatureSupport.isSubModule(leaf1, leaf2)) continue;
                conflicts.add(leaf1);
                conflicts.add(leaf2);
            }
        }
        if (conflicts.isEmpty()) {
            ArrayList<MavenProject> devModeProjects = new ArrayList<MavenProject>();
            for (MavenProject leaf : leaves) {
                devModeProjects.addAll(graph.getUpstreamProjects(leaf, true));
                devModeProjects.add(leaf);
            }
            this.getLog().debug((CharSequence)"Resolved multi-module projects: ");
            for (MavenProject project : devModeProjects) {
                this.getLog().debug((CharSequence)project.getArtifactId());
            }
            return devModeProjects;
        }
        ArrayList<String> conflictModuleRelativeDirs = new ArrayList<String>();
        for (MavenProject conflict : conflicts) {
            conflictModuleRelativeDirs.add(this.getModuleRelativePath(conflict));
        }
        throw new MojoExecutionException("Found multiple independent modules in the Reactor build order: " + conflictModuleRelativeDirs + ". Skip a conflicting module in the Liberty configuration or specify the module containing the Liberty configuration that you want to use for the server by including the following parameters in the Maven command: -pl <module-with-liberty-config> -am");
    }

    private boolean skipConfigured(MavenProject project) {
        Properties props = project.getProperties();
        Properties userProps = this.session.getUserProperties();
        Plugin libertyPlugin = this.getLibertyPluginForProject(project);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "dev", this.getLog());
        return DevHelper.getBooleanFlag(config, userProps, props, "skip");
    }

    protected boolean containsPreviousLibertyModule(ProjectDependencyGraph graph) {
        MavenProject reactorProject;
        List sortedReactorProjects = graph.getSortedProjects();
        MavenProject mostDownstreamModule = null;
        Iterator iterator = sortedReactorProjects.iterator();
        while (iterator.hasNext() && !(reactorProject = (MavenProject)iterator.next()).equals((Object)this.project)) {
            if (!graph.getDownstreamProjects(reactorProject, true).isEmpty()) continue;
            mostDownstreamModule = reactorProject;
            break;
        }
        if (mostDownstreamModule != null && !mostDownstreamModule.equals((Object)this.project)) {
            this.getLog().debug((CharSequence)("Found a previous module in the Reactor build order that does not have downstream dependencies: " + mostDownstreamModule));
            if (ServerFeatureSupport.isSubModule(this.project, mostDownstreamModule)) {
                this.getLog().debug((CharSequence)"Detected that this multi module pom contains another module that does not have downstream dependencies. Skipping goal on this module.");
                return true;
            }
        }
        return false;
    }

    protected String getModuleRelativePath(MavenProject module) {
        return this.multiModuleProjectDirectory.toPath().relativize(module.getBasedir().toPath()).toString();
    }

    protected Plugin getLibertyPluginForProject(MavenProject currentProject) {
        Plugin projectPlugin;
        String version = null;
        if (this.plugin != null && this.plugin.getPlugin() != null) {
            version = this.plugin.getVersion();
            this.getLog().debug((CharSequence)("Setting plugin version to " + version));
        }
        if ((projectPlugin = currentProject.getPlugin("io.openliberty.tools:liberty-maven-plugin")) == null) {
            this.getLog().debug((CharSequence)("Did not find liberty-maven-plugin configured in currentProject: " + currentProject.toString()));
            projectPlugin = this.getPluginFromPluginManagement(LIBERTY_MAVEN_PLUGIN_GROUP_ID, LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID, currentProject);
        } else {
            this.getLog().debug((CharSequence)("Found liberty-maven-plugin configured in currentProject: " + currentProject.toString()));
        }
        if (projectPlugin == null) {
            this.getLog().debug((CharSequence)("Did not find liberty-maven-plugin in pluginManagement in currentProject: " + currentProject.toString()));
            projectPlugin = MojoExecutor.plugin((String)LIBERTY_MAVEN_PLUGIN_GROUP_ID, (String)LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID, (String)"LATEST");
        }
        if (version != null) {
            projectPlugin.setVersion(version);
        }
        return projectPlugin;
    }

    protected Plugin getPluginFromPluginManagement(String groupId, String artifactId, MavenProject currentProject) {
        Plugin retVal = null;
        PluginManagement pm = currentProject.getPluginManagement();
        if (pm != null) {
            for (Plugin p : pm.getPlugins()) {
                if (!groupId.equals(p.getGroupId()) || !artifactId.equals(p.getArtifactId())) continue;
                retVal = p;
                break;
            }
        }
        return retVal;
    }

    protected Plugin getPluginForProject(String groupId, String artifactId, MavenProject currentProject) {
        Plugin plugin = currentProject.getPlugin(groupId + ":" + artifactId);
        if (plugin == null) {
            plugin = this.getPluginFromPluginManagement(groupId, artifactId, currentProject);
        }
        if (plugin == null) {
            plugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)"RELEASE"));
        }
        return plugin;
    }

    protected class ServerFeatureMojoUtil
    extends ServerFeatureUtil {
        protected ServerFeatureMojoUtil() {
        }

        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                ServerFeatureSupport.this.getLog().debug((CharSequence)msg);
            }
        }

        public void debug(String msg, Throwable e) {
            if (this.isDebugEnabled()) {
                ServerFeatureSupport.this.getLog().debug((CharSequence)msg, e);
            }
        }

        public void debug(Throwable e) {
            if (this.isDebugEnabled()) {
                ServerFeatureSupport.this.getLog().debug(e);
            }
        }

        public void warn(String msg) {
            if (!this.suppressLogs) {
                ServerFeatureSupport.this.getLog().warn((CharSequence)msg);
            } else {
                this.debug(msg);
            }
        }

        public void info(String msg) {
            if (!this.suppressLogs) {
                ServerFeatureSupport.this.getLog().info((CharSequence)msg);
            } else {
                this.debug(msg);
            }
        }

        public void error(String msg, Throwable e) {
            ServerFeatureSupport.this.getLog().error((CharSequence)msg, e);
        }

        public void error(String msg) {
            ServerFeatureSupport.this.getLog().error((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return ServerFeatureSupport.this.getLog().isDebugEnabled();
        }
    }
}

