/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class PackageServerMojo
extends StartDebugMojoSupport {
    private PackageFileType packageFileType = null;
    private File packageFile = null;
    @Parameter(property="packageType")
    private String packageType;
    @Parameter(property="packageName")
    private String packageName;
    @Parameter(property="packageDirectory")
    private String packageDirectory;
    @Parameter(property="include")
    private String include;
    @Parameter(property="serverRoot")
    private String serverRoot;
    @Parameter(property="os")
    private String os;
    @Parameter
    private boolean attach;
    @Parameter(property="skipLibertyPackage", defaultValue="false")
    protected boolean skipLibertyPackage = false;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.defaultOutputDirSet) {
            this.outputDirectory = new File(this.project.getBuild().getDirectory(), "liberty-alt-output-dir");
        }
        if (this.skip || this.skipLibertyPackage) {
            this.getLog().info((CharSequence)"\nSkipping package goal.\n");
            return;
        }
        try {
            this.doPackage();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error packaging the Liberty server.", (Exception)e);
        }
    }

    private void doPackage() throws MojoExecutionException, IOException {
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.package"), this.serverName));
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("package");
        this.setAndCreatePackageFilePath();
        serverTask.setArchive(this.packageFile);
        serverTask.setInclude(this.include);
        serverTask.setOs(this.os);
        serverTask.setServerRoot(this.serverRoot);
        this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.package.file.location"), this.packageFile.getCanonicalPath()));
        serverTask.execute();
        if ("liberty-assembly".equals(this.project.getPackaging())) {
            this.project.getArtifact().setFile(this.packageFile);
        } else if (this.attach) {
            if (!this.packageFileType.getValue().equalsIgnoreCase(this.project.getPackaging())) {
                throw new MojoExecutionException("packageType must match project packaging type.");
            }
            this.project.getArtifact().setFile(this.packageFile);
        }
    }

    private ArrayList<String> parseInclude() {
        ArrayList<String> includeValues;
        if (this.include != null && !this.include.isEmpty()) {
            this.include = this.include.trim();
            List<String> includeStrings = Arrays.asList(this.include.split(","));
            includeValues = new ArrayList<String>(includeStrings);
            for (int i = 0; i < includeValues.size(); ++i) {
                String value = includeValues.get(i);
                if (value.trim().length() <= 0) continue;
                includeValues.set(i, value.trim());
            }
        } else {
            includeValues = new ArrayList<String>();
        }
        return includeValues;
    }

    private void setAndCreatePackageFilePath() throws IOException, MojoExecutionException {
        this.setPackageFileType();
        File projectBuildDir = this.getPackageDirectory();
        this.createDir(projectBuildDir);
        String projectBuildName = this.getPackageName();
        this.packageFile = new File(projectBuildDir, projectBuildName + "." + this.packageFileType.getValue());
    }

    private void setPackageFileType() throws MojoExecutionException {
        ArrayList<String> includeValues = this.parseInclude();
        if (this.packageType == null) {
            if (includeValues.contains("runnable")) {
                this.getLog().debug((CharSequence)"Defaulting `packageType` to `jar` because the `include` value contains `runnable`.");
                this.packageFileType = PackageFileType.JAR;
            } else {
                this.getLog().debug((CharSequence)"Defaulting `packageType` to `zip`.");
                this.packageFileType = PackageFileType.ZIP;
            }
        } else {
            PackageFileType packType = PackageFileType.getPackageFileType(this.packageType);
            if (packType != null) {
                if (includeValues.contains("runnable") && packType != PackageFileType.JAR) {
                    throw new MojoExecutionException("The `include` value `runnable` requires a `packageType` value of `jar`.");
                }
                this.packageFileType = packType;
            } else {
                this.getLog().info((CharSequence)("The `packageType` value " + this.packageType + " is not supported. Defaulting to 'zip'."));
                this.packageFileType = PackageFileType.ZIP;
            }
        }
    }

    private String getPackageName() {
        if (this.packageName != null && !this.packageName.isEmpty()) {
            return this.packageName;
        }
        this.packageName = this.project.getBuild().getFinalName();
        return this.packageName;
    }

    private File getPackageDirectory() throws IOException {
        if (this.packageDirectory != null && !this.packageDirectory.isEmpty()) {
            File dir = new File(this.packageDirectory);
            if (dir.isAbsolute()) {
                return dir.getCanonicalFile();
            }
            File packageDir = new File(this.project.getBuild().getDirectory(), this.packageDirectory);
            return packageDir.getCanonicalFile();
        }
        File packageDir = new File(this.project.getBuild().getDirectory());
        return packageDir.getCanonicalFile();
    }

    private void createDir(File dir) throws MojoExecutionException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Unable to create directory " + dir.getPath());
        }
    }

    private static enum PackageFileType {
        JAR("jar"),
        TAR("tar"),
        TARGZ("tar.gz"),
        ZIP("zip");

        private final String value;
        private static final Map<String, PackageFileType> lookup;

        private PackageFileType(String val) {
            this.value = val;
        }

        public static PackageFileType getPackageFileType(String input) {
            return lookup.get(input);
        }

        public String getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<String, PackageFileType>();
            for (PackageFileType s : EnumSet.allOf(PackageFileType.class)) {
                lookup.put(s.value, s);
            }
        }
    }
}

