/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.scheduling;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.framework.AopProxyUtils;

@Aspect
final class SpringSchedulingInstrumentationAspect {
    public static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-scheduling-3.1";
    private final Instrumenter<ClassAndMethod, Object> instrumenter;

    public SpringSchedulingInstrumentationAspect(OpenTelemetry openTelemetry, ConfigProperties configProperties) {
        CodeAttributesGetter codedAttributesGetter = ClassAndMethod.codeAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)CodeSpanNameExtractor.create((CodeAttributesGetter)codedAttributesGetter)).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)codedAttributesGetter));
        if (configProperties.getBoolean("otel.instrumentation.spring-scheduling.experimental-span-attributes", false)) {
            builder.addAttributesExtractor(AttributesExtractor.constant((AttributeKey)AttributeKey.stringKey((String)"job.system"), (Object)"spring_scheduling"));
        }
        this.instrumenter = builder.buildInstrumenter();
    }

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)|| @annotation(org.springframework.scheduling.annotation.Schedules)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object execution(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        block9: {
            ClassAndMethod request;
            Context parent = Context.current();
            if (!this.instrumenter.shouldStart(parent, (Object)(request = ClassAndMethod.create((Class)AopProxyUtils.ultimateTargetClass((Object)joinPoint.getTarget()), (String)((MethodSignature)joinPoint.getSignature()).getMethod().getName())))) {
                return joinPoint.proceed();
            }
            Context context = this.instrumenter.start(parent, (Object)request);
            Scope ignored = context.makeCurrent();
            try {
                Object object2 = joinPoint.proceed();
                this.instrumenter.end(context, (Object)request, object2, null);
                object = object2;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.instrumenter.end(context, (Object)request, null, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return object;
    }
}

