/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.observation;

import io.micrometer.observation.transport.ReceiverContext;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;

public class KafkaRecordReceiverContext
extends ReceiverContext<ConsumerRecord<?, ?>> {
    private final String receiverId;

    public KafkaRecordReceiverContext(ConsumerRecord<?, ?> record, String receiverId, String kafkaServers) {
        super((carrier, key) -> {
            Header header = carrier.headers().lastHeader(key);
            if (header == null) {
                return null;
            }
            return new String(header.value(), StandardCharsets.UTF_8);
        });
        this.setCarrier(record);
        this.receiverId = receiverId;
        this.setRemoteServiceName("Apache Kafka: " + kafkaServers);
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public String getSource() {
        return ((ConsumerRecord)this.getCarrier()).topic();
    }
}

