/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.spring.boot;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingjdbc.core.api.MasterSlaveDataSourceFactory;
import io.shardingjdbc.core.api.ShardingDataSourceFactory;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.constant.ShardingPropertiesConstant;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.util.DataSourceUtil;
import io.shardingjdbc.spring.boot.masterslave.SpringBootMasterSlaveRuleConfigurationProperties;
import io.shardingjdbc.spring.boot.sharding.SpringBootShardingRuleConfigurationProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootMasterSlaveRuleConfigurationProperties.class})
public class SpringBootConfiguration
implements EnvironmentAware {
    @Autowired
    private SpringBootShardingRuleConfigurationProperties shardingProperties;
    @Autowired
    private SpringBootMasterSlaveRuleConfigurationProperties masterSlaveProperties;
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final Properties props = new Properties();

    @Bean
    public DataSource dataSource() throws SQLException {
        return null == this.masterSlaveProperties.getMasterDataSourceName() ? ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)this.shardingProperties.getShardingRuleConfiguration(), (Properties)this.props) : MasterSlaveDataSourceFactory.createDataSource(this.dataSourceMap, (MasterSlaveRuleConfiguration)this.masterSlaveProperties.getMasterSlaveRuleConfiguration());
    }

    public void setEnvironment(Environment environment) {
        this.setDataSourceMap(environment);
        this.setShardingProperties(environment);
    }

    private void setDataSourceMap(Environment environment) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "sharding.jdbc.datasource.");
        String dataSources = propertyResolver.getProperty("names");
        for (String each : dataSources.split(",")) {
            try {
                Map dataSourceProps = propertyResolver.getSubProperties(each + ".");
                Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
                DataSource dataSource = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
                this.dataSourceMap.put(each, dataSource);
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingJdbcException("Can't find datasource type!", (Exception)ex);
            }
        }
    }

    private void setShardingProperties(Environment environment) {
        String executorSize;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "sharding.jdbc.config.sharding.props.");
        String showSQL = propertyResolver.getProperty(ShardingPropertiesConstant.SQL_SHOW.getKey());
        if (!Strings.isNullOrEmpty((String)showSQL)) {
            this.props.setProperty(ShardingPropertiesConstant.SQL_SHOW.getKey(), showSQL);
        }
        if (!Strings.isNullOrEmpty((String)(executorSize = propertyResolver.getProperty(ShardingPropertiesConstant.EXECUTOR_SIZE.getKey())))) {
            this.props.setProperty(ShardingPropertiesConstant.EXECUTOR_SIZE.getKey(), executorSize);
        }
    }
}

