/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.operators;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.operators.ProcessorBase;

public class Transform<I, O>
implements Flow.Publisher<O> {
    private final Flow.Publisher<I> upstream;
    private final Function<I, O> function;

    public Transform(Flow.Publisher<I> upstream, Function<I, O> function) {
        this.upstream = Objects.requireNonNull(upstream, "The upstream cannot be null");
        this.function = Objects.requireNonNull(function, "The function cannot be null");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super O> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Processor processor = new Processor();
        processor.subscribe(subscriber);
        this.upstream.subscribe(processor);
    }

    private class Processor
    extends ProcessorBase<I, O> {
        private Processor() {
        }

        @Override
        public void onNext(I item) {
            if (!this.cancelled()) {
                try {
                    Object result = Transform.this.function.apply(item);
                    if (result == null) {
                        throw new NullPointerException("The function produced a null result for item " + String.valueOf(item));
                    }
                    this.downstream().onNext(result);
                }
                catch (Throwable failure) {
                    this.cancel();
                    this.downstream().onError(failure);
                }
            }
        }
    }
}

