/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle;

import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.gradle.FormatterTask;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class CheckTask
extends FormatterTask {
    public static final String NAME = "checkFormat";
    public static final String DESCRIPTION = "Run Spring Java formatting checks";

    public CheckTask() {
        this.getOutputs().upToDateWhen(task -> true);
    }

    @TaskAction
    public void checkFormatting() throws IOException, InterruptedException {
        List problems = this.formatFiles().filter(FileEdit::hasEdits).map(FileEdit::getFile).collect(Collectors.toList());
        if (!problems.isEmpty()) {
            StringBuilder message = new StringBuilder("Formatting violations found in the following files:\n");
            problems.stream().forEach(f -> message.append(" * " + f + "\n"));
            message.append("\nRun `format` to fix.");
            throw new GradleException(message.toString());
        }
    }
}

