/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency;

import com.alibaba.nacos.common.utils.Observable;
import com.alibaba.nacos.common.utils.Observer;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.javatuples.Pair;

public final class ProtocolMetaData {
    private final Map<String, MetaData> metaDataMap = new ConcurrentHashMap<String, MetaData>(4);

    public Map<String, Map<Object, Object>> getMetaDataMap() {
        return this.metaDataMap.entrySet().stream().map(entry -> Pair.with((Object)((String)entry.getKey()), (Object)((MetaData)entry.getValue()).getItemMap().entrySet().stream().collect(TreeMap::new, (m, e) -> m.put(e.getKey(), ((ValueItem)((Object)((Object)((Object)e.getValue())))).getData()), TreeMap::putAll))).collect(TreeMap::new, (m, e) -> m.put((String)e.getValue0(), (Map)e.getValue1()), TreeMap::putAll);
    }

    public void load(Map<String, Map<String, Object>> mapMap) {
        mapMap.forEach((s, map) -> {
            this.metaDataMap.computeIfAbsent((String)s, MetaData::new);
            MetaData data = this.metaDataMap.get(s);
            map.forEach(data::put);
        });
    }

    public Object get(String group, String subKey) {
        if (StringUtils.isBlank((CharSequence)subKey)) {
            return this.metaDataMap.get(group);
        }
        if (this.metaDataMap.containsKey(group)) {
            return this.metaDataMap.get(group).get(subKey);
        }
        return null;
    }

    public void subscribe(String group, String key, Observer observer) {
        this.metaDataMap.computeIfAbsent(group, s -> new MetaData(group));
        this.metaDataMap.get(group).subscribe(key, observer);
    }

    public void unSubscribe(String group, String key, Observer observer) {
        this.metaDataMap.computeIfAbsent(group, s -> new MetaData(group));
        this.metaDataMap.get(group).unSubscribe(key, observer);
    }

    public static final class ValueItem
    extends Observable {
        private final transient String path;
        private final transient ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final transient ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        private final transient ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        private volatile Object data;

        public ValueItem(String path) {
            this.path = path;
        }

        public Object getData() {
            this.readLock.lock();
            try {
                Object object = this.data;
                return object;
            }
            finally {
                this.readLock.unlock();
            }
        }

        void setData(Object data) {
            this.writeLock.lock();
            try {
                this.data = data;
                this.setChanged();
                this.notifyObservers();
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String getPath() {
            return this.path;
        }
    }

    public static final class MetaData {
        private final Map<String, ValueItem> itemMap = new ConcurrentHashMap<String, ValueItem>(8);
        private final transient String group;

        public MetaData(String group) {
            this.group = group;
        }

        public Map<String, ValueItem> getItemMap() {
            return this.itemMap;
        }

        void put(String key, Object value) {
            this.itemMap.computeIfAbsent(key, s -> new ValueItem(this.group + "/" + key));
            ValueItem item = this.itemMap.get(key);
            item.setData(value);
        }

        public ValueItem get(String key) {
            return this.itemMap.get(key);
        }

        void subscribe(String key, Observer observer) {
            this.itemMap.computeIfAbsent(key, s -> new ValueItem(this.group + "/" + key));
            ValueItem item = this.itemMap.get(key);
            item.addObserver(observer);
        }

        void unSubscribe(String key, Observer observer) {
            ValueItem item = this.itemMap.get(key);
            if (item == null) {
                return;
            }
            item.deleteObserver(observer);
        }
    }
}

